/*
 * Decompiled with CFR 0.152.
 */
package ro.flcristian.terraformer.utility.schematics;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.function.Supplier;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.querz.nbt.io.NBTDeserializer;
import net.querz.nbt.io.NamedTag;
import net.querz.nbt.tag.CompoundTag;
import net.querz.nbt.tag.IntTag;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import ro.flcristian.terraformer.utility.Pair;
import ro.flcristian.terraformer.utility.schematics.SchematicParser;
import ro.flcristian.terraformer.utility.schematics.records.SchematicBlockPos;
import ro.flcristian.terraformer.utility.schematics.records.SchematicData;

public class SchematicParserImpl
implements SchematicParser {
    private static final Supplier<SchematicParserImpl> instance = new Supplier<SchematicParserImpl>(){
        private final SchematicParserImpl singletonInstance = new SchematicParserImpl();

        @Override
        public SchematicParserImpl get() {
            return this.singletonInstance;
        }
    };

    private SchematicParserImpl() {
    }

    public static SchematicParserImpl getInstance() {
        return instance.get();
    }

    @Override
    public SchematicData readSchematicFile(Player player, File file) throws IOException {
        NBTDeserializer deserializer = new NBTDeserializer();
        NamedTag namedTag = (NamedTag)deserializer.fromFile(file);
        CompoundTag root = (CompoundTag)namedTag.getTag();
        CompoundTag schematic = root.containsKey("Schematic") ? root.getCompoundTag("Schematic") : root;
        int width = schematic.getShort("Width");
        int height = schematic.getShort("Height");
        int length = schematic.getShort("Length");
        CompoundTag blockContainer = schematic.containsKey("Blocks") ? schematic.getCompoundTag("Blocks") : schematic;
        byte[] blockData = blockContainer.containsKey("Data") ? blockContainer.getByteArray("Data") : blockContainer.getByteArray("BlockData");
        CompoundTag palette = blockContainer.containsKey("Palette") ? blockContainer.getCompoundTag("Palette") : schematic.getCompoundTag("Palette");
        HashMap<Integer, String> paletteMap = new HashMap<Integer, String>();
        paletteMap.put(0, "minecraft:air");
        if (palette != null) {
            palette.forEach((key, value) -> {
                if (value instanceof IntTag) {
                    int id = ((IntTag)value).asInt();
                    paletteMap.put(id, (String)key);
                }
            });
        }
        ArrayList<Pair<SchematicBlockPos, String>> blocksList = new ArrayList<Pair<SchematicBlockPos, String>>();
        for (int y = 0; y < height; ++y) {
            for (int z = 0; z < length; ++z) {
                for (int i = 0; i < width; ++i) {
                    int index = y * width * length + z * width + i;
                    if (index >= blockData.length) continue;
                    int blockId = blockData[index] & 0xFF;
                    SchematicBlockPos pos = new SchematicBlockPos(i, y, z);
                    String blockType = (String)paletteMap.get(blockId);
                    blocksList.add(new Pair<SchematicBlockPos, String>(pos, blockType));
                }
            }
        }
        boolean invalidMaterials = false;
        for (Pair pair : blocksList) {
            String checkBlockData = (String)pair.getSecond();
            try {
                int colonIndex = checkBlockData.indexOf(":");
                int bracketIndex = checkBlockData.indexOf("[");
                if (colonIndex == -1) continue;
                String materialName = bracketIndex != -1 ? checkBlockData.substring(colonIndex + 1, bracketIndex) : checkBlockData.substring(colonIndex + 1);
                Material.valueOf((String)materialName.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                invalidMaterials = true;
            }
        }
        if (invalidMaterials) {
            player.sendMessage(Component.text((String)"Invalid blocks in schematic, probably from older versions or mods. The schematic will still work, but might not look the same as it should have.").color((TextColor)NamedTextColor.RED));
        }
        return new SchematicData(width, height, length, blocksList);
    }
}

