/*
 * Decompiled with CFR 0.152.
 */
package top.diaoyugan.vein_mine.client.render;

import com.mojang.blaze3d.opengl.GlStateManager;
import net.minecraft.class_1921;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import org.joml.Matrix4f;
import top.diaoyugan.vein_mine.client.ClientBlockHighlighting;
import top.diaoyugan.vein_mine.client.render.CustomLayers;
import top.diaoyugan.vein_mine.config.ConfigItems;
import top.diaoyugan.vein_mine.config.IntrusiveConfig;
import top.diaoyugan.vein_mine.utils.Utils;

public class RenderOutlines {
    protected static boolean initialized = false;
    private static final int[][] EDGES = new int[][]{{0, 1}, {1, 2}, {2, 3}, {3, 0}, {4, 5}, {5, 6}, {6, 7}, {7, 4}, {0, 4}, {1, 5}, {2, 6}, {3, 7}};

    public static void renderHighlights(class_4587 matrices, class_4597.class_4598 vertexConsumers, class_4184 camera) {
        if (class_310.method_1551().field_1687 == null || ClientBlockHighlighting.HIGHLIGHTED_BLOCKS.isEmpty()) {
            return;
        }
        if (!initialized) {
            initialized = true;
            CustomLayers.init();
        }
        class_243 camPos = camera.method_19326();
        RenderOutlines.prepareGlState();
        matrices.method_22903();
        class_1921.class_4687 layer = IntrusiveConfig.isEnabled() ? CustomLayers.getLinesNoDepth() : class_1921.method_34572();
        Color color = RenderOutlines.getConfigColor();
        for (class_2338 pos : ClientBlockHighlighting.HIGHLIGHTED_BLOCKS) {
            class_4588 buffer = vertexConsumers.method_73477((class_1921)layer);
            RenderOutlines.drawOutlineBox(matrices, buffer, pos, camPos, color, 0.01f);
        }
        matrices.method_22909();
        RenderOutlines.resetGlState();
    }

    private static void prepareGlState() {
        GlStateManager._disableDepthTest();
        GlStateManager._depthMask((boolean)false);
        GlStateManager._enableBlend();
    }

    private static void resetGlState() {
        GlStateManager._depthMask((boolean)true);
        GlStateManager._enableDepthTest();
        GlStateManager._disableBlend();
    }

    private static Color getConfigColor() {
        ConfigItems config = Utils.getConfig();
        return new Color((float)config.red / 255.0f, (float)config.green / 255.0f, (float)config.blue / 255.0f, (float)config.alpha / 255.0f);
    }

    private static void drawOutlineBox(class_4587 matrices, class_4588 consumer, class_2338 pos, class_243 camPos, Color color, float thickness) {
        double x = (double)pos.method_10263() - camPos.field_1352;
        double y = (double)pos.method_10264() - camPos.field_1351;
        double z = (double)pos.method_10260() - camPos.field_1350;
        class_243[] corners = new class_243[]{new class_243(x, y, z), new class_243(x + 1.0, y, z), new class_243(x + 1.0, y + 1.0, z), new class_243(x, y + 1.0, z), new class_243(x, y, z + 1.0), new class_243(x + 1.0, y, z + 1.0), new class_243(x + 1.0, y + 1.0, z + 1.0), new class_243(x, y + 1.0, z + 1.0)};
        Matrix4f matrix = matrices.method_23760().method_23761();
        for (int[] edge : EDGES) {
            RenderOutlines.drawLineAsQuad(consumer, matrix, corners[edge[0]], corners[edge[1]], thickness, color);
        }
    }

    private static void drawLineAsQuad(class_4588 consumer, Matrix4f matrix, class_243 p1, class_243 p2, float thickness, Color color) {
        class_243 dir = p2.method_1020(p1).method_1029();
        class_243 up = Math.abs(dir.field_1351) > 0.999 ? new class_243(1.0, 0.0, 0.0) : new class_243(0.0, 1.0, 0.0);
        class_243 side = dir.method_1036(up).method_1029().method_1021((double)(thickness / 2.0f));
        class_243 p1a = p1.method_1019(side);
        class_243 p1b = p1.method_1020(side);
        class_243 p2a = p2.method_1019(side);
        class_243 p2b = p2.method_1020(side);
        RenderOutlines.drawTriangle(consumer, matrix, p1a, p2a, p2b, color);
        RenderOutlines.drawTriangle(consumer, matrix, p2b, p1b, p1a, color);
    }

    private static void drawTriangle(class_4588 consumer, Matrix4f matrix, class_243 v1, class_243 v2, class_243 v3, Color color) {
        consumer.method_22918(matrix, (float)v1.field_1352, (float)v1.field_1351, (float)v1.field_1350).method_22915(color.r, color.g, color.b, color.a).method_22913(0.0f, 0.0f).method_22914(0.0f, 1.0f, 0.0f);
        consumer.method_22918(matrix, (float)v2.field_1352, (float)v2.field_1351, (float)v2.field_1350).method_22915(color.r, color.g, color.b, color.a).method_22913(0.0f, 0.0f).method_22914(0.0f, 1.0f, 0.0f);
        consumer.method_22918(matrix, (float)v3.field_1352, (float)v3.field_1351, (float)v3.field_1350).method_22915(color.r, color.g, color.b, color.a).method_22913(0.0f, 0.0f).method_22914(0.0f, 1.0f, 0.0f);
    }

    private record Color(float r, float g, float b, float a) {
    }
}

