/*
 * Decompiled with CFR 0.152.
 */
package top.diaoyugan.vein_mine.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import top.diaoyugan.vein_mine.config.ConfigItems;
import top.diaoyugan.vein_mine.config.IntrusiveConfig;
import top.diaoyugan.vein_mine.utils.logging.Logger;
import top.diaoyugan.vein_mine.utils.logging.LoggerLevels;

public class Config {
    private final Path configFilePath = Paths.get("config/vein_mine.json", new String[0]);
    private final Gson jsonProcessor = new GsonBuilder().setPrettyPrinting().create();
    private ConfigItems configItems = new ConfigItems();
    private static Config instance;

    public static Config getInstance() {
        if (instance == null) {
            instance = new Config();
        }
        return instance;
    }

    private Config() {
        try {
            Files.createDirectories(this.configFilePath.getParent(), new FileAttribute[0]);
            if (!Files.exists(this.configFilePath, new LinkOption[0])) {
                this.save();
            }
            this.load();
        }
        catch (Exception e) {
            Logger.throwLog(LoggerLevels.ERROR, "Failed to initialize the configuration", e);
        }
    }

    public void save() {
        try (BufferedWriter writer = Files.newBufferedWriter(this.configFilePath, new OpenOption[0]);){
            this.jsonProcessor.toJson((Object)this.configItems, (Appendable)writer);
        }
        catch (Exception e) {
            Logger.throwLog(LoggerLevels.ERROR, "Failed to save the configuration", e);
        }
    }

    public void load() {
        try (BufferedReader reader = Files.newBufferedReader(this.configFilePath);){
            ConfigItems loadedConfig = (ConfigItems)this.jsonProcessor.fromJson((Reader)reader, ConfigItems.class);
            if (loadedConfig != null) {
                this.configItems = loadedConfig;
                IntrusiveConfig.load(this.configItems);
            } else {
                this.configItems = new ConfigItems();
                this.save();
            }
        }
        catch (JsonSyntaxException e) {
            Logger.throwLog(LoggerLevels.ERROR, "The configuration file is malformed, reset to the default configuration");
            this.configItems = new ConfigItems();
            this.save();
        }
        catch (IOException e) {
            Logger.throwLog(LoggerLevels.ERROR, "Failed to read the configuration file, using the default configuration");
            this.configItems = new ConfigItems();
        }
    }

    public ConfigItems getConfigItems() {
        return this.configItems;
    }
}

