/*
 * Decompiled with CFR 0.152.
 */
package top.diaoyugan.vein_mine.events;

import java.util.List;
import net.fabricmc.fabric.api.event.player.PlayerBlockBreakEvents;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1303;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import net.minecraft.class_7923;
import top.diaoyugan.vein_mine.config.ConfigItems;
import top.diaoyugan.vein_mine.utils.Messages;
import top.diaoyugan.vein_mine.utils.SmartVein;
import top.diaoyugan.vein_mine.utils.Utils;

public class PlayerBreakBlock {
    public static void register() {
        PlayerBlockBreakEvents.AFTER.register(PlayerBreakBlock::onBlockBreak);
    }

    private static void onBlockBreak(class_1937 world, class_1657 player, class_2338 pos, class_2680 state, class_2586 entity) {
        if (!Utils.getVeinMineSwitchState(player)) {
            return;
        }
        List<class_2338> blocks = SmartVein.findBlocks(world, pos, class_7923.field_41175.method_10221((Object)state.method_26204()));
        if (blocks == null || blocks.isEmpty()) {
            return;
        }
        if (!PlayerBreakBlock.checkDurabilityAndWarn(player, state, blocks)) {
            return;
        }
        int destroyed = PlayerBreakBlock.breakBlocks(world, player, pos, state, blocks);
        Utils.applyToolDurabilityDamage(player, destroyed);
    }

    private static boolean checkDurabilityAndWarn(class_1657 player, class_2680 state, List<class_2338> blocks) {
        ConfigItems config = Utils.getConfig();
        if (!config.protectTools || player.method_56992()) {
            return true;
        }
        int totalCost = Utils.calculateTotalDurabilityCost(blocks, player, state);
        if (Utils.hasEnoughDurability(player, totalCost)) {
            return true;
        }
        if (player instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)player;
            class_5250 msg = class_2561.method_43471((String)"vm.warn.breakthroughs").method_27694(s -> s.method_27706(class_124.field_1061));
            Messages.sendMessage(serverPlayer, (class_2561)msg, true);
        }
        return false;
    }

    private static int breakBlocks(class_1937 world, class_1657 player, class_2338 centerPos, class_2680 originalState, List<class_2338> blocks) {
        int count = 0;
        for (class_2338 pos : blocks) {
            if (pos.equals((Object)centerPos)) continue;
            count += PlayerBreakBlock.breakSingleBlock(world, player, centerPos, pos, originalState);
        }
        return count;
    }

    private static int breakSingleBlock(class_1937 world, class_1657 player, class_2338 centerPos, class_2338 targetPos, class_2680 originalState) {
        class_2680 targetState = world.method_8320(targetPos);
        if (targetState.method_26204() != originalState.method_26204()) {
            return 0;
        }
        if (PlayerBreakBlock.shouldDropItems(player, targetState, world, targetPos)) {
            class_2248.method_9511((class_2680)targetState, (class_1937)world, (class_2338)targetPos, (class_2586)world.method_8321(targetPos), (class_1297)player, (class_1799)player.method_6047());
        }
        world.method_22352(targetPos, false);
        if (world instanceof class_3218) {
            class_3218 serverWorld = (class_3218)world;
            PlayerBreakBlock.moveDropsToCenter(serverWorld, centerPos);
        }
        return 1;
    }

    private static boolean shouldDropItems(class_1657 player, class_2680 state, class_1937 world, class_2338 pos) {
        if (player.method_56992()) {
            return false;
        }
        if (!Utils.isToolSuitable(state, player)) {
            return false;
        }
        return !Utils.shouldNotDropItem(state, world, pos);
    }

    private static void moveDropsToCenter(class_3218 world, class_2338 centerPos) {
        class_243 center = class_243.method_24953((class_2382)centerPos);
        List drops = world.method_8390(class_1297.class, new class_238(centerPos).method_1014(6.0), e -> e instanceof class_1542 || e instanceof class_1303);
        drops.forEach(drop -> drop.method_33574(center));
    }
}

