/*
 * Decompiled with CFR 0.152.
 */
package top.diaoyugan.vein_mine.utils;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_7923;
import top.diaoyugan.vein_mine.utils.Utils;
import top.diaoyugan.vein_mine.utils.logging.Logger;
import top.diaoyugan.vein_mine.utils.logging.LoggerLevels;

public class SmartVein {
    public static List<class_2338> findBlocks(class_1937 world, class_2338 startPos) {
        class_2680 startState = world.method_8320(startPos);
        class_2960 blockID = class_7923.field_41175.method_10221((Object)startState.method_26204());
        String startBlockID = blockID.toString();
        if (Utils.getConfig().ignoredBlocks.contains(startBlockID) || !Utils.getConfig().useBFS) {
            return SmartVein.findBlocksInCube(world, startPos, startState);
        }
        return SmartVein.findConnectedBlocks(world, startPos, startState);
    }

    public static List<class_2338> findBlocks(class_1937 world, class_2338 startPos, class_2960 startBlockID) {
        if (Utils.getConfig().ignoredBlocks.contains(String.valueOf(startBlockID)) || !Utils.getConfig().useBFS) {
            return SmartVein.findBlocksInCube(world, startPos, startBlockID);
        }
        return SmartVein.findConnectedBlocks(world, startPos, startBlockID);
    }

    private static List<class_2338> findBlocksInCube(class_1937 world, class_2338 pos, class_2680 targetState) {
        if (!Utils.getConfig().useRadiusSearch) {
            return null;
        }
        ArrayList<class_2338> foundBlocks = new ArrayList<class_2338>();
        int radius = Utils.getConfig().searchRadius;
        for (int x = -radius; x <= radius; ++x) {
            for (int y = -radius; y <= radius; ++y) {
                for (int z = -radius; z <= radius; ++z) {
                    class_2338 targetPos = pos.method_10069(x, y, z);
                    if (world.method_8320(targetPos).method_26204() != targetState.method_26204()) continue;
                    foundBlocks.add(targetPos);
                }
            }
        }
        return foundBlocks;
    }

    private static List<class_2338> findBlocksInCube(class_1937 world, class_2338 pos, class_2960 startBlockID) {
        if (!Utils.getConfig().useRadiusSearch) {
            return null;
        }
        ArrayList<class_2338> foundBlocks = new ArrayList<class_2338>();
        class_2248 block = (class_2248)class_7923.field_41175.method_63535(startBlockID);
        int radius = Utils.getConfig().searchRadius;
        for (int x = -radius; x <= radius; ++x) {
            for (int y = -radius; y <= radius; ++y) {
                for (int z = -radius; z <= radius; ++z) {
                    class_2338 targetPos = pos.method_10069(x, y, z);
                    if (world.method_8320(targetPos).method_26204() != block) continue;
                    foundBlocks.add(targetPos);
                }
            }
        }
        return foundBlocks;
    }

    private static List<class_2338> findConnectedBlocks(class_1937 world, class_2338 startPos, class_2680 targetState) {
        ArrayList<class_2338> foundBlocks = new ArrayList<class_2338>();
        HashSet<class_2338> visited = new HashSet<class_2338>();
        LinkedList<class_2338> queue = new LinkedList<class_2338>();
        queue.add(startPos);
        visited.add(startPos);
        int connectedCount = 0;
        while (!queue.isEmpty()) {
            class_2338 current = (class_2338)queue.poll();
            foundBlocks.add(current);
            if (++connectedCount > Utils.getConfig().BFSLimit) {
                if (Utils.getConfig().useRadiusSearchWhenReachBFSLimit) {
                    return SmartVein.findBlocksInCube(world, startPos, targetState);
                }
                return null;
            }
            for (class_2338 offset : SmartVein.getAllNeighborOffsets()) {
                class_2338 neighborPos = current.method_10081((class_2382)offset);
                if (visited.contains(neighborPos) || !SmartVein.isSameBlock(world, targetState, neighborPos)) continue;
                queue.add(neighborPos);
                visited.add(neighborPos);
            }
        }
        return foundBlocks;
    }

    private static List<class_2338> findConnectedBlocks(class_1937 world, class_2338 startPos, class_2960 startBlockID) {
        ArrayList<class_2338> foundBlocks = new ArrayList<class_2338>();
        HashSet<class_2338> visited = new HashSet<class_2338>();
        LinkedList<class_2338> queue = new LinkedList<class_2338>();
        class_2248 block = (class_2248)class_7923.field_41175.method_63535(startBlockID);
        class_2680 startState = block.method_9564();
        queue.add(startPos);
        visited.add(startPos);
        int connectedCount = 0;
        while (!queue.isEmpty()) {
            class_2338 current = (class_2338)queue.poll();
            foundBlocks.add(current);
            if (++connectedCount > Utils.getConfig().BFSLimit) {
                if (Utils.getConfig().useRadiusSearchWhenReachBFSLimit) {
                    return SmartVein.findBlocksInCube(world, startPos, startBlockID);
                }
                return null;
            }
            for (class_2338 offset : SmartVein.getAllNeighborOffsets()) {
                class_2338 neighborPos = current.method_10081((class_2382)offset);
                if (visited.contains(neighborPos) || !SmartVein.isSameBlock(world, startState, neighborPos)) continue;
                queue.add(neighborPos);
                visited.add(neighborPos);
            }
        }
        return foundBlocks;
    }

    private static List<class_2338> getAllNeighborOffsets() {
        ArrayList<class_2338> offsets = new ArrayList<class_2338>();
        for (int x = -1; x <= 1; ++x) {
            for (int y = -1; y <= 1; ++y) {
                for (int z = -1; z <= 1; ++z) {
                    if (x == 0 && y == 0 && z == 0) continue;
                    offsets.add(new class_2338(x, y, z));
                }
            }
        }
        return offsets;
    }

    private static boolean isSameBlock(class_1937 world, class_2680 targetState, class_2338 pos) {
        return world.method_8320(pos).method_26204() == targetState.method_26204();
    }

    static {
        block2: {
            try {
                Utils.getConfig().ignoredBlocks.add("minecraft:air");
            }
            catch (Exception e) {
                if (e instanceof UnsupportedOperationException) break block2;
                Logger.throwLog(LoggerLevels.ERROR, String.valueOf(e), e.fillInStackTrace());
            }
        }
    }
}

