/*
 * Decompiled with CFR 0.152.
 */
package net.justsunnit.fern.DataTypes;

import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.util.HashMap;
import java.util.List;
import net.justsunnit.fern.DataTypes.BaseDataType;
import net.justsunnit.fern.FernServerInit;

public class PermissionInPlayer
implements BaseDataType {
    public HashMap<String, playerData> data = new HashMap();

    @Override
    public void addPermission(String UUID, String permission, String PlayerUser) {
        this.checkFile();
        if (this.data.containsKey(UUID)) {
            playerData pData = this.data.get(UUID);
            if (!pData.permissions.contains(permission)) {
                pData.permissions.add(permission);
            }
        }
        this.write();
    }

    @Override
    public boolean checkPermission(String UUID, String permission) {
        this.checkFile();
        if (this.data.containsKey(UUID)) {
            playerData pData = this.data.get(UUID);
            return pData.permissions.contains(permission);
        }
        return false;
    }

    @Override
    public boolean checkGroupPermission(String groupName, String UUID) {
        this.checkFile();
        if (this.data.containsKey(UUID)) {
            playerData pData = this.data.get(UUID);
            return pData.permissions.stream().anyMatch(s -> s.startsWith(groupName));
        }
        return false;
    }

    @Override
    public void removePermission(String UUID, String permission) {
        this.checkFile();
        if (this.data.containsKey(UUID)) {
            playerData pData = this.data.get(UUID);
            pData.permissions.remove(permission);
        }
        this.write();
    }

    @Override
    public void setPlayerUser(String UUID, String playerUser) {
        this.checkFile();
        if (this.data.containsKey(UUID)) {
            playerData pData = this.data.get(UUID);
            pData.playerUser = playerUser;
        } else {
            playerData pData = new playerData(playerUser, List.of());
            this.data.put(UUID, pData);
        }
        this.write();
    }

    @Override
    public void write() {
        try (FileWriter writer = new FileWriter(baseData);){
            gson.toJson(this.data, (Appendable)writer);
        }
        catch (Exception e) {
            FernServerInit.LOGGER.error("[Fern] Failed to write data file!");
        }
    }

    @Override
    public void load() {
        if (!baseData.exists()) {
            try (FileWriter writer = new FileWriter(baseData);){
                PermissionInPlayer data = new PermissionInPlayer();
                gson.toJson((Object)data, (Appendable)writer);
            }
            catch (Exception e) {
                FernServerInit.LOGGER.error("[Fern] Failed to create data file!");
            }
        } else {
            try (FileReader reader = new FileReader(baseData);){
                PermissionInPlayer permissionInPlayer = (PermissionInPlayer)gson.fromJson((Reader)reader, PermissionInPlayer.class);
            }
            catch (Exception e) {
                FernServerInit.LOGGER.error("[Fern] Failed to read data file!");
            }
        }
    }

    public static class playerData {
        public String playerUser;
        public List<String> permissions;

        public playerData(String playerUser, List<String> permissions) {
            this.playerUser = playerUser;
            this.permissions = permissions;
        }
    }
}

