/*
 * Decompiled with CFR 0.152.
 */
package net.justsunnit.fern.DataTypes;

import com.google.gson.Gson;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import net.fabricmc.loader.api.FabricLoader;
import net.justsunnit.fern.FernServerInit;

public class PlayerDirectory {
    private static final Gson gson = new Gson();
    private static final File file = FabricLoader.getInstance().getConfigDir().resolve("fern_directory.json").toFile();
    public static HashMap<String, String> directory = new HashMap();

    public static void addPlayer(String UUID, String playerUser) {
        PlayerDirectory.checkFile();
        if (directory.containsKey(UUID)) {
            FernServerInit.LOGGER.info("[Fern] Player with UUID " + UUID + " already exists in directory, updating username.");
        }
        directory.put(UUID, playerUser);
        PlayerDirectory.write();
    }

    public static String getUsername(String UUID) {
        PlayerDirectory.checkFile();
        if (directory.containsKey(UUID)) {
            return directory.get(UUID);
        }
        FernServerInit.LOGGER.error("[Fern] Player with UUID " + UUID + " not found in directory.");
        return null;
    }

    public static String getUUID(String playerUser) {
        PlayerDirectory.checkFile();
        return directory.entrySet().stream().filter(entry -> ((String)entry.getValue()).equals(playerUser)).map(Map.Entry::getKey).findFirst().orElseGet(() -> {
            FernServerInit.LOGGER.error("[Fern] Player with username " + playerUser + " not found in directory.");
            return null;
        });
    }

    private static void write() {
        if (!file.exists()) {
            try {
                file.createNewFile();
            }
            catch (Exception e) {
                FernServerInit.LOGGER.error("[Fern] Failed to create player directory file!");
                return;
            }
        }
        try (FileWriter writer = new FileWriter(file);){
            gson.toJson(directory, (Appendable)writer);
        }
        catch (Exception e) {
            FernServerInit.LOGGER.error("[Fern] Failed to write player directory file!");
        }
    }

    private static void load() {
        if (!file.exists()) {
            PlayerDirectory.write();
        }
        try (FileReader reader = new FileReader(file);){
            directory = (HashMap)gson.fromJson((Reader)reader, HashMap.class);
        }
        catch (Exception e) {
            FernServerInit.LOGGER.error("[Fern] Failed to load player directory file!");
        }
    }

    private static void checkFile() {
        if (!file.exists() || directory.isEmpty()) {
            PlayerDirectory.load();
        }
    }
}

