/*
 * Decompiled with CFR 0.152.
 */
package net.justsunnit.fern.Utility;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import net.fabricmc.loader.api.FabricLoader;
import net.justsunnit.fern.FernServerInit;

public class ConfigHandler {
    public static File configFile = FabricLoader.getInstance().getConfigDir().resolve("fern.json").toFile();
    public static int dataType = 0;
    private static final Gson gson = new GsonBuilder().setPrettyPrinting().create();
    private static Config config = new Config();

    public static void load() {
        if (!configFile.exists()) {
            FernServerInit.LOGGER.warn("[Fern] Config file not found, creating default config.");
            ConfigHandler.save();
        }
        try (FileReader reader = new FileReader(configFile);){
            config = (Config)gson.fromJson((Reader)reader, Config.class);
            FernServerInit.LOGGER.info("[Fern] Config file loaded successfully.");
        }
        catch (Exception e) {
            FernServerInit.LOGGER.error("[Fern] Failed to load config file!");
            e.printStackTrace();
        }
        dataType = ConfigHandler.config.dataType;
    }

    public static void save() {
        try (FileWriter writer = new FileWriter(configFile);){
            gson.toJson((Object)config, (Appendable)writer);
        }
        catch (Exception e) {
            FernServerInit.LOGGER.error("[Fern] Failed to save config file!");
        }
    }

    public static void reload() {
        ConfigHandler.load();
    }

    public static class Config {
        public int dataType = 0;
    }
}

