/*
 * Decompiled with CFR 0.152.
 */
package net.kappasmp.kappasanticheat.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;

public class AntiCheatConfig {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final File CONFIG_FILE = new File("config/kappasac/config.json");
    private static AntiCheatConfig instance;
    public Map<String, CheckConfig> checks = new HashMap<String, CheckConfig>();
    public int warningThreshold = 5;
    public int maxThreshold = 10;
    public String commandOnMax = "kick %player% Detected cheating (%check%)";

    public static AntiCheatConfig get() {
        if (instance == null) {
            AntiCheatConfig.load();
        }
        return instance;
    }

    public static void load() {
        try {
            if (!CONFIG_FILE.exists()) {
                instance = new AntiCheatConfig();
                instance.initDefaults();
                AntiCheatConfig.save();
            } else {
                FileReader reader = new FileReader(CONFIG_FILE);
                instance = (AntiCheatConfig)GSON.fromJson((Reader)reader, AntiCheatConfig.class);
                reader.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            instance = new AntiCheatConfig();
            instance.initDefaults();
        }
    }

    public static void save() {
        try {
            CONFIG_FILE.getParentFile().mkdirs();
            FileWriter writer = new FileWriter(CONFIG_FILE);
            GSON.toJson((Object)instance, (Appendable)writer);
            writer.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void initDefaults() {
        this.checks.put("FlyCheck", new CheckConfig(true, 10));
        this.checks.put("SpeedCheck", new CheckConfig(true, 10));
    }

    public static class CheckConfig {
        public boolean enabled;
        public int maxViolations;

        public CheckConfig(boolean enabled, int maxViolations) {
            this.enabled = enabled;
            this.maxViolations = maxViolations;
        }
    }
}

