/*
 * Decompiled with CFR 0.152.
 */
package net.kappasmp.kappasanticheat.detection;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.kappasmp.kappasanticheat.detection.DetectionCheck;
import net.kappasmp.kappasanticheat.detection.DetectionManager;
import net.minecraft.class_2338;
import net.minecraft.class_3218;
import net.minecraft.class_3222;

public class FlyCheck
implements DetectionCheck {
    private static final int MAX_AIR_TICKS = 15;
    private final Map<UUID, Integer> airTicks = new HashMap<UUID, Integer>();

    @Override
    public String getName() {
        return "FlyCheck";
    }

    @Override
    public boolean shouldRunOnMove() {
        return true;
    }

    @Override
    public void check(class_3222 player) {
        if (this.isExempt(player)) {
            this.airTicks.remove(player.method_5667());
            return;
        }
        boolean isAir = this.isInAir(player);
        int ticks = this.airTicks.getOrDefault(player.method_5667(), 0);
        ticks = isAir ? ++ticks : 0;
        this.airTicks.put(player.method_5667(), ticks);
        if (ticks > 15) {
            DetectionManager.addViolation(player, this.getName());
        }
    }

    private boolean isExempt(class_3222 player) {
        return player.method_68878() || player.method_7325() || player.method_31549().field_7479 || player.method_5854() != null;
    }

    private boolean isInAir(class_3222 player) {
        class_3218 world = player.method_51469();
        class_2338 pos = player.method_24515().method_10074();
        return world.method_22347(pos);
    }
}

