/*
 * Decompiled with CFR 0.152.
 */
package net.kappasmp.kappasanticheat.detection;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.kappasmp.kappasanticheat.config.AntiCheatConfig;
import net.kappasmp.kappasanticheat.detection.DetectionCheck;
import net.kappasmp.kappasanticheat.detection.FlyCheck;
import net.kappasmp.kappasanticheat.detection.SpeedCheck;
import net.minecraft.class_2561;
import net.minecraft.class_3222;

public class DetectionManager {
    private static final List<DetectionCheck> CHECKS = new ArrayList<DetectionCheck>();
    private static final Map<UUID, Map<String, Integer>> VIOLATION_MAP = new HashMap<UUID, Map<String, Integer>>();

    public static void registerAll() {
        DetectionManager.register(new FlyCheck());
        DetectionManager.register(new SpeedCheck());
    }

    public static void register(DetectionCheck check) {
        CHECKS.add(check);
    }

    public static void handleMove(class_3222 player) {
        for (DetectionCheck check : CHECKS) {
            String checkName = check.getName();
            AntiCheatConfig.CheckConfig config = AntiCheatConfig.get().checks.get(checkName);
            if (config == null || !config.enabled || !check.shouldRunOnMove()) continue;
            check.check(player);
        }
    }

    public static void addViolation(class_3222 player, String checkName) {
        AntiCheatConfig.CheckConfig checkConfig = AntiCheatConfig.get().checks.get(checkName);
        if (checkConfig == null || !checkConfig.enabled) {
            return;
        }
        UUID uuid = player.method_5667();
        VIOLATION_MAP.putIfAbsent(uuid, new HashMap());
        Map<String, Integer> playerViolations = VIOLATION_MAP.get(uuid);
        int newCount = playerViolations.getOrDefault(checkName, 0) + 1;
        playerViolations.put(checkName, newCount);
        int warnThreshold = AntiCheatConfig.get().warningThreshold;
        int maxThreshold = checkConfig.maxViolations;
        if (newCount == warnThreshold) {
            player.method_7353((class_2561)class_2561.method_43470((String)("\u00a7c[Kappa'sAC] Warning: Suspicious behavior detected: " + checkName)), false);
        }
        if (newCount >= maxThreshold) {
            String command = AntiCheatConfig.get().commandOnMax.replace("%player%", player.method_5477().getString()).replace("%check%", checkName);
            player.method_5682().method_3734().method_44252(player.method_5682().method_3739(), command);
        }
    }

    public static int getViolations(class_3222 player, String checkName) {
        return VIOLATION_MAP.getOrDefault(player.method_5667(), Collections.emptyMap()).getOrDefault(checkName, 0);
    }
}

