/*
 * Decompiled with CFR 0.152.
 */
package net.kappasmp.kappasanticheat.detection;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.kappasmp.kappasanticheat.detection.DetectionCheck;
import net.kappasmp.kappasanticheat.detection.DetectionManager;
import net.minecraft.class_1304;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2338;
import net.minecraft.class_3218;
import net.minecraft.class_3222;

public class FlyCheck
implements DetectionCheck {
    private static final int MAX_AIR_TICKS = 15;
    private static final int GRACE_TICKS_BEFORE_VIOLATION = 100;
    private final Map<UUID, Integer> airTicks = new HashMap<UUID, Integer>();
    private final Map<UUID, Integer> violationTimer = new HashMap<UUID, Integer>();

    @Override
    public String getName() {
        return "FlyCheck";
    }

    @Override
    public boolean shouldRunOnMove() {
        return true;
    }

    @Override
    public void check(class_3222 player) {
        if (this.isExempt(player)) {
            this.clear(player);
            return;
        }
        UUID uuid = player.method_5667();
        boolean isAir = this.isInAir(player);
        int currentAirTicks = this.airTicks.getOrDefault(uuid, 0);
        currentAirTicks = isAir ? currentAirTicks + 1 : 0;
        this.airTicks.put(uuid, currentAirTicks);
        if (currentAirTicks < 15) {
            this.violationTimer.remove(uuid);
            return;
        }
        int grace = this.violationTimer.getOrDefault(uuid, 0) + 1;
        this.violationTimer.put(uuid, grace);
        if (grace >= 100) {
            DetectionManager.addViolation(player, this.getName());
        }
    }

    private boolean isInAir(class_3222 player) {
        class_3218 world = player.method_51469();
        class_2338 below = player.method_24515().method_10074();
        return world.method_22347(below);
    }

    private boolean isExempt(class_3222 player) {
        return player.method_68878() || player.method_7325() || player.method_31549().field_7479 || player.method_5854() != null || this.isUsingElytra(player);
    }

    private boolean isUsingElytra(class_3222 player) {
        class_1799 chest = this.getChestplate(player);
        return chest.method_31574(class_1802.field_8833) && chest.method_7919() < chest.method_7936();
    }

    private class_1799 getChestplate(class_3222 player) {
        return player.method_6118(class_1304.field_6174);
    }

    private void clear(class_3222 player) {
        UUID uuid = player.method_5667();
        this.airTicks.remove(uuid);
        this.violationTimer.remove(uuid);
    }
}

