/*
 * Decompiled with CFR 0.152.
 */
package net.kappasmp.kappasanticheat.detection;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.kappasmp.kappasanticheat.detection.DetectionCheck;
import net.kappasmp.kappasanticheat.detection.DetectionManager;
import net.minecraft.class_1294;
import net.minecraft.class_1304;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_243;
import net.minecraft.class_3222;

public class SpeedCheck
implements DetectionCheck {
    private static final double MAX_ALLOWED_SPEED = 0.55;
    private static final int MAX_SAFE_PING = 250;
    private static final int GRACE_TICKS_BEFORE_VIOLATION = 100;
    private final Map<UUID, class_243> lastPositions = new HashMap<UUID, class_243>();
    private final Map<UUID, Long> lastTickTimes = new HashMap<UUID, Long>();
    private final Map<UUID, Integer> violationTimer = new HashMap<UUID, Integer>();

    @Override
    public String getName() {
        return "SpeedCheck";
    }

    @Override
    public boolean shouldRunOnMove() {
        return true;
    }

    @Override
    public void check(class_3222 player) {
        if (this.isExempt(player)) {
            this.clear(player);
            return;
        }
        UUID uuid = player.method_5667();
        class_243 current = player.method_19538();
        class_243 last = this.lastPositions.get(uuid);
        long now = System.currentTimeMillis();
        long lastTime = this.lastTickTimes.getOrDefault(uuid, now);
        if (last != null && now > lastTime + 40L) {
            double distance = current.method_1022(last);
            double blocksPerTick = distance / ((double)(now - lastTime) / 50.0);
            if (blocksPerTick > 0.55) {
                int ticks = this.violationTimer.getOrDefault(uuid, 0) + 1;
                this.violationTimer.put(uuid, ticks);
                if (ticks >= 100) {
                    DetectionManager.addViolation(player, this.getName());
                }
            } else {
                this.violationTimer.remove(uuid);
            }
        }
        this.lastPositions.put(uuid, current);
        this.lastTickTimes.put(uuid, now);
    }

    private boolean isExempt(class_3222 player) {
        return player.method_68878() || player.method_7325() || player.method_31549().field_7479 || player.method_5854() != null || player.method_6059(class_1294.field_5904) || player.field_13987.method_52405() > 250 || this.isGliding(player);
    }

    private boolean isGliding(class_3222 player) {
        class_1799 chest = player.method_6118(class_1304.field_6174);
        if (!chest.method_31574(class_1802.field_8833)) {
            return false;
        }
        return player.method_18798().field_1351 < -0.1;
    }

    private void clear(class_3222 player) {
        UUID uuid = player.method_5667();
        this.lastPositions.remove(uuid);
        this.lastTickTimes.remove(uuid);
        this.violationTimer.remove(uuid);
    }
}

