/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebossmagnus.mods.config_manager.common;

import io.github.thebossmagnus.mods.config_manager.common.Services;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;

public class AddFlagsUtil {
    private static boolean UPDATE_FLAG = false;
    private static boolean OVERWRITE_FLAG = false;

    public static boolean isUpdateFlag() {
        return UPDATE_FLAG;
    }

    public static void setUpdateFlag(boolean updateFlag) {
        UPDATE_FLAG = updateFlag;
        AddFlagsUtil.addFlags();
    }

    public static boolean isOverwriteFlag() {
        return OVERWRITE_FLAG;
    }

    public static void setOverwriteFlag(boolean overwriteFlag) {
        OVERWRITE_FLAG = overwriteFlag;
        AddFlagsUtil.addFlags();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void addFlags() throws RuntimeException {
        Path gameDir = Services.PLATFORM.getGameDir();
        if (OVERWRITE_FLAG) {
            Path flag = gameDir.resolve("config").resolve("CONFIG_MANAGER_RESET_FLAG");
            try {
                Files.createFile(flag, new FileAttribute[0]);
                return;
            }
            catch (IOException e) {
                if (Files.exists(flag, new LinkOption[0])) return;
                throw new RuntimeException("Could not create CONFIG_MANAGER_RESET_FLAG", e);
            }
        }
        if (!UPDATE_FLAG) return;
        Path flag = gameDir.resolve("config").resolve("CONFIG_MANAGER_UPDATE_FLAG");
        try {
            Files.createFile(flag, new FileAttribute[0]);
            return;
        }
        catch (IOException e) {
            if (Files.exists(flag, new LinkOption[0])) return;
            throw new RuntimeException("Could not create CONFIG_MANAGER_UPDATE_FLAG", e);
        }
    }
}

