/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebossmagnus.mods.config_manager.common_coremod;

import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.stream.Stream;
import org.apache.logging.log4j.Logger;

public final class OverwriteConfig {
    private static final String DIR_NAME = "modpack_defaults";

    public static void run(Path gameDir, Logger LOGGER) {
        Path configDir = gameDir.resolve("config");
        Path defaultsDir = configDir.resolve(DIR_NAME);
        if (!Files.exists(defaultsDir, new LinkOption[0])) {
            return;
        }
        try (Stream<Path> paths = Files.walk(defaultsDir, new FileVisitOption[0]);){
            paths.filter(path -> !path.equals(defaultsDir)).forEach(source -> {
                Path relative = defaultsDir.relativize((Path)source);
                Path target = gameDir.resolve(relative);
                try {
                    if (Files.isDirectory(source, new LinkOption[0])) {
                        Files.createDirectories(target, new FileAttribute[0]);
                    } else {
                        Files.createDirectories(target.getParent(), new FileAttribute[0]);
                        Files.copy(source, target, StandardCopyOption.REPLACE_EXISTING);
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException("Error copying " + String.valueOf(source) + " to " + String.valueOf(target), e);
                }
            });
            LOGGER.info("Config files updated");
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to copy modpack_defaults", e);
        }
    }
}

