/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebossmagnus.mods.config_manager.common_coremod;

import io.github.thebossmagnus.mods.config_manager.common_coremod.Constants;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.stream.Stream;

public final class OverwriteConfig {
    public static void run(Path gameDir) {
        Path configDir = gameDir.resolve("config");
        Path defaultsDir = configDir.resolve("modpack_defaults");
        if (!Files.exists(defaultsDir, new LinkOption[0])) {
            return;
        }
        try (Stream<Path> paths = Files.walk(defaultsDir, new FileVisitOption[0]);){
            paths.filter(path -> !path.equals(defaultsDir)).forEach(source -> {
                Path relative = defaultsDir.relativize((Path)source);
                Path target = gameDir.resolve(relative);
                try {
                    if (Files.isDirectory(source, new LinkOption[0])) {
                        Files.createDirectories(target, new FileAttribute[0]);
                    } else {
                        Files.createDirectories(target.getParent(), new FileAttribute[0]);
                        Files.copy(source, target, StandardCopyOption.REPLACE_EXISTING);
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException("Error copying " + String.valueOf(source) + " to " + String.valueOf(target), e);
                }
            });
            Constants.LOGGER.info("Config files updated");
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to copy modpack_defaults", e);
        }
    }
}

