/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebossmagnus.mods.config_manager.common_coremod;

import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.stream.Stream;

public final class CopyConfig {
    private static final String dirName = "modpack_defaults";

    public static void init(Path gameDir) {
        Path configDir = gameDir.resolve("config").resolve(dirName);
        if (!Files.exists(configDir, new LinkOption[0])) {
            return;
        }
        Path nestedDir = configDir.resolve(dirName);
        if (Files.exists(nestedDir, new LinkOption[0])) {
            throw new RuntimeException(String.format("A subfolder called \"%s\" is inside config/%s: %s", dirName, dirName, nestedDir));
        }
        try (Stream<Path> paths = Files.walk(configDir, new FileVisitOption[0]);){
            paths.filter(path -> !path.equals(configDir)).forEach(source -> {
                Path relative = configDir.relativize((Path)source);
                Path target = gameDir.resolve(relative);
                if (Files.exists(target, new LinkOption[0])) {
                    return;
                }
                try {
                    if (Files.isDirectory(source, new LinkOption[0])) {
                        Files.createDirectories(target, new FileAttribute[0]);
                    } else {
                        Files.createDirectories(target.getParent(), new FileAttribute[0]);
                        Files.copy(source, target, new CopyOption[0]);
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException("Error copying " + String.valueOf(source) + " to " + String.valueOf(target), e);
                }
            });
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to copy modpack_defaults", e);
        }
    }
}

