/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebossmagnus.mods.config_manager.core_mod.services;

import cpw.mods.jarhandling.SecureJar;
import java.nio.file.Path;
import java.util.List;
import java.util.Optional;
import net.neoforged.fml.loading.moddiscovery.locators.JarInJarDependencyLocator;
import net.neoforged.fml.loading.moddiscovery.readers.JarModsDotTomlModFileReader;
import net.neoforged.neoforgespi.locating.IDependencyLocator;
import net.neoforged.neoforgespi.locating.IDiscoveryPipeline;
import net.neoforged.neoforgespi.locating.IModFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigManagerDependencyLocator
extends JarInJarDependencyLocator
implements IDependencyLocator {
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"ConfigManagerDependencyLocator");

    public void scanMods(List<IModFile> loadedMods, IDiscoveryPipeline pipeline) {
        try {
            Path jarPath = Path.of(ConfigManagerDependencyLocator.class.getProtectionDomain().getCodeSource().getLocation().toURI());
            SecureJar secureJar = SecureJar.from((Path[])new Path[]{jarPath});
            IModFile modFile = IModFile.create((SecureJar)secureJar, JarModsDotTomlModFileReader::manifestParser);
            Path innerJarPath = Path.of("META-INF", "jarjar", "config_manager-neoforge.jar");
            Optional neoForgeMod = this.loadModFileFrom(modFile, innerJarPath, pipeline);
            neoForgeMod.ifPresent(arg_0 -> ((IDiscoveryPipeline)pipeline).addModFile(arg_0));
        }
        catch (Exception e) {
            LOGGER.error("Error while adding config_manager-neoforge.jar to pipeline: ", (Throwable)e);
        }
    }
}

