/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebossmagnus.mods.config_manager.common_coremod;

import io.github.thebossmagnus.mods.config_manager.common_coremod.Constants;
import io.github.thebossmagnus.mods.config_manager.common_coremod.CopyConfig;
import io.github.thebossmagnus.mods.config_manager.common_coremod.OverwriteConfig;
import io.github.thebossmagnus.mods.config_manager.common_coremod.ResetAndCopyConfig;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;

public final class ConfigManagerStartup {
    public static void run(Path gameDir) {
        Path configDir = gameDir.resolve("config");
        Path resetFlag = configDir.resolve("CONFIG_MANAGER_RESET_FLAG");
        Path updateFlag = configDir.resolve("CONFIG_MANAGER_UPDATE_FLAG");
        try {
            if (Files.exists(resetFlag, new LinkOption[0])) {
                Constants.LOGGER.info("Flag detected, running a config reset");
                ResetAndCopyConfig.run(gameDir);
                Files.deleteIfExists(resetFlag);
                Files.deleteIfExists(updateFlag);
            } else if (Files.exists(updateFlag, new LinkOption[0])) {
                Constants.LOGGER.info("Flag detected, running a config update");
                OverwriteConfig.run(gameDir);
                Files.deleteIfExists(updateFlag);
            } else {
                Constants.LOGGER.info("No flag found, running a usual copy");
                CopyConfig.init(gameDir);
            }
        }
        catch (Exception e) {
            Constants.LOGGER.error("Error during config copy: ", (Throwable)e);
            throw new RuntimeException(e);
        }
    }
}

