/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebossmagnus.mods.config_manager.common_coremod;

import io.github.thebossmagnus.mods.config_manager.common_coremod.OverwriteConfig;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.stream.Stream;

public final class ResetAndCopyConfig {
    public static void run(Path gameDir) {
        Path configDir = gameDir.resolve("config");
        try (Stream<Path> stream = Files.list(configDir);){
            stream.filter(path -> !path.getFileName().toString().equals("modpack_defaults")).forEach(ResetAndCopyConfig::deleteRecursively);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to clean config directory", e);
        }
        OverwriteConfig.run(gameDir);
    }

    private static void deleteRecursively(Path path) {
        try {
            if (Files.isDirectory(path, new LinkOption[0])) {
                try (Stream<Path> entries = Files.list(path);){
                    entries.forEach(ResetAndCopyConfig::deleteRecursively);
                }
            }
            Files.deleteIfExists(path);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to delete " + String.valueOf(path), e);
        }
    }
}

