/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebossmagnus.mods.config_manager.common;

import io.github.thebossmagnus.mods.config_manager.common.Constants;
import io.github.thebossmagnus.mods.config_manager.common.Services;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.atomic.AtomicBoolean;

public class AddFlagsUtil {
    private static final AtomicBoolean UPDATE_FLAG = new AtomicBoolean(false);
    private static final AtomicBoolean OVERWRITE_FLAG = new AtomicBoolean(false);

    public static void setUpdateFlag(boolean updateFlag) {
        UPDATE_FLAG.set(updateFlag);
        AddFlagsUtil.addFlags();
    }

    public static void setOverwriteFlag(boolean overwriteFlag) {
        OVERWRITE_FLAG.set(overwriteFlag);
        AddFlagsUtil.addFlags();
    }

    private static void addFlags() throws RuntimeException {
        Path gameDir = Services.PLATFORM.getGameDir();
        Path configDir = gameDir.resolve("config");
        try {
            if (!Files.exists(configDir, new LinkOption[0])) {
                Files.createDirectories(configDir, new FileAttribute[0]);
            }
        }
        catch (IOException e) {
            Constants.LOGGER.error("Could not create config directory: {}", (Object)configDir, (Object)e);
            throw new RuntimeException("Could not create config directory", e);
        }
        if (OVERWRITE_FLAG.get()) {
            AddFlagsUtil.createFlagFile(configDir, "CONFIG_MANAGER_RESET_FLAG");
        } else if (UPDATE_FLAG.get()) {
            AddFlagsUtil.createFlagFile(configDir, "CONFIG_MANAGER_UPDATE_FLAG");
        }
    }

    private static void createFlagFile(Path configDir, String flagFileName) {
        block2: {
            Path flag = configDir.resolve(flagFileName);
            try {
                Files.createFile(flag, new FileAttribute[0]);
            }
            catch (IOException e) {
                if (Files.exists(flag, new LinkOption[0])) break block2;
                Constants.LOGGER.error("Could not create {}: {}", (Object)flagFileName, (Object)flag, (Object)e);
                throw new RuntimeException("Could not create " + flagFileName, e);
            }
        }
    }
}

