/*
 * Decompiled with CFR 0.152.
 */
package io.github.flo12344.cobblestats.common;

import com.cobblemon.mod.common.client.CobblemonClient;
import com.cobblemon.mod.common.client.battle.ActiveClientBattlePokemon;
import com.cobblemon.mod.common.client.battle.ClientBattle;
import com.cobblemon.mod.common.client.battle.ClientBattlePokemon;
import com.cobblemon.mod.common.net.messages.client.battle.BattleMessagePacket;
import io.github.flo12344.cobblestats.common.BattleStateTracker;
import io.github.flo12344.cobblestats.common.PokemonBattleState;
import io.github.flo12344.cobblestats.common.TerrainBattleState;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_5250;
import net.minecraft.class_7417;
import net.minecraft.class_8828;

public class BattleProcess {
    private static final int BG = -2003989107;
    private static final int BORDER = -13684945;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void drawUI(class_332 context, ActiveClientBattlePokemon activeBattlePokemon, boolean left, int rank, boolean isHovered, boolean isCompact) {
        int x_pos;
        Object text;
        class_310 mc = class_310.method_1551();
        ClientBattlePokemon battlePokemon = activeBattlePokemon.getBattlePokemon();
        if (battlePokemon == null) {
            return;
        }
        ClientBattle battle = CobblemonClient.INSTANCE.getBattle();
        if (battle == null) {
            return;
        }
        int playerNumberOffset = (Character.getNumericValue(activeBattlePokemon.getActorShowdownId().charAt(1)) - 1) / 2 * 10;
        float original_Y = 10 + rank * (isCompact ? 30 : 40) + (left ? playerNumberOffset : (battle.getBattleFormat().getBattleType().getActorsPerSide() - 1) * 10 - playerNumberOffset);
        float original_X = activeBattlePokemon.getXDisplacement();
        int portraitOffsetY = isCompact ? 7 : 8;
        int portraitDiameter = isCompact ? 19 : 28;
        int infoOffsetX = isCompact ? 6 : 7;
        original_X += left ? (float)(infoOffsetX + portraitDiameter) : 0.0f;
        original_Y += (float)portraitOffsetY + (float)portraitDiameter * 0.75f;
        int hue = activeBattlePokemon.getHue();
        float r = (float)(hue >> 16 & 0xFF) / 255.0f;
        float g = (float)(hue >> 8 & 0xFF) / 255.0f;
        float b = (float)(hue & 0xFF) / 255.0f;
        Object key = ((class_2588)activeBattlePokemon.getBattlePokemon().getDisplayName().method_10851()).method_11022();
        class_7417 class_74172 = activeBattlePokemon.getBattlePokemon().getActor().getDisplayName().method_10851();
        if (class_74172 instanceof class_8828.class_2585) {
            String text1;
            class_8828.class_2585 class_25852 = (class_8828.class_2585)class_74172;
            try {
                String string;
                text1 = string = class_25852.comp_737();
            }
            catch (Throwable throwable) {
                throw new MatchException(throwable.toString(), throwable);
            }
            key = text1 + "/" + (String)key;
        }
        List<String> stats = BattleStateTracker.getChangedStats((String)key);
        float maxX = isCompact ? 95.0f : 95.0f;
        float[] x = new float[]{original_X += 5.0f};
        float[] finalOriginal_X = new float[]{original_X};
        if (activeBattlePokemon.getBattlePokemon().getStatus() != null) {
            if (left) {
                x[0] = x[0] + 35.0f;
            } else {
                finalOriginal_X[0] = finalOriginal_X[0] - 35.0f;
            }
        }
        float scale = 0.5f;
        float[] y = new float[]{original_Y};
        stats.forEach(s -> {
            if (x[0] + (float)((int)((float)mc.field_1772.method_1727(s) * 0.5f)) > finalOriginal_X[0] + maxX) {
                x[0] = finalOriginal_X[0];
                float f = y[0];
                Objects.requireNonNull(mc.field_1772);
                y[0] = f + (9.0f * 0.5f + 3.0f);
            }
            x[0] = BattleProcess.drawStats(context, mc.field_1772, s, (int)x[0], (int)y[0], 0.5f, 0xFFFFFF) + 3;
        });
        int[] _y = new int[]{(int)(original_Y + (float)(isCompact ? 19 : 28))};
        TerrainBattleState.getHazardStates(left).forEach((s, integer) -> {
            Object text = s;
            if (integer > 1) {
                text = (String)text + " " + integer;
            }
            int _x = 10;
            if (!left) {
                _x = mc.method_22683().method_4486() - _x - (int)((float)mc.field_1772.method_1727((String)text) * 0.5f);
            }
            BattleProcess.drawStats(context, mc.field_1772, (String)text, _x, _y[0], 0.5f, 0xFFFFFF);
            int n = _y[0];
            Objects.requireNonNull(mc.field_1772);
            _y[0] = n + ((int)(9.0f * 0.5f) + 3);
        });
        if (!left) return;
        int[] y_pos = new int[]{10};
        if (!((String)TerrainBattleState.getTerrainState()[0]).isEmpty()) {
            Object[] terrain = TerrainBattleState.getTerrainState();
            text = (String)terrain[0];
            text = (Integer)terrain[1] < 0 ? (String)text + " " + ((Integer)terrain[1] + 3) : (String)text + " " + String.valueOf(terrain[1]) + " or " + ((Integer)terrain[1] + 3);
            x_pos = mc.method_22683().method_4486() / 2 - (int)((float)mc.field_1772.method_1727((String)text) / 2.0f * 0.5f);
            BattleProcess.drawStats(context, mc.field_1772, (String)text, x_pos, y_pos[0], 0.5f, 0xFFFFFF);
            int n = y_pos[0];
            Objects.requireNonNull(mc.field_1772);
            y_pos[0] = n + ((int)(9.0f * 0.5f) + 3);
        }
        TerrainBattleState.getRoomState().forEach((s, integer) -> {
            String text = s + " " + integer;
            int x_pos = mc.method_22683().method_4486() / 2 - (int)((float)mc.field_1772.method_1727(text) / 2.0f * 0.5f);
            BattleProcess.drawStats(context, mc.field_1772, text, x_pos, y_pos[0], 0.5f, 0xFFFFFF);
            int n = y_pos[0];
            Objects.requireNonNull(mc.field_1772);
            y_pos[0] = n + ((int)(9.0f * 0.5f) + 3);
        });
        if (((String)TerrainBattleState.getWeatherState()[0]).isEmpty()) return;
        Object[] weather = TerrainBattleState.getWeatherState();
        text = (String)weather[0];
        text = (Integer)weather[1] < 0 ? (String)text + " " + ((Integer)weather[1] + 3) : (String)text + " " + String.valueOf(weather[1]) + " or " + ((Integer)weather[1] + 3);
        x_pos = mc.method_22683().method_4486() / 2 - (int)((float)mc.field_1772.method_1727((String)text) / 2.0f * 0.5f);
        BattleProcess.drawStats(context, mc.field_1772, (String)text, x_pos, y_pos[0], 0.5f, 0xFFFFFF);
        int n = y_pos[0];
        Objects.requireNonNull(mc.field_1772);
        y_pos[0] = n + ((int)(9.0f * 0.5f) + 3);
    }

    public static Object[] processBattleData(BattleMessagePacket messagePacket, String current_atk, String current_pkm, PokemonBattleState tmp_stat_holder) {
        String[] MainActionSplit = ((class_2588)((class_2561)messagePacket.getMessages().getFirst()).method_10851()).method_11022().split("\\.");
        if (MainActionSplit.length < 3 || !Objects.equals(MainActionSplit[1], "battle")) {
            return new Object[]{current_atk, current_pkm, tmp_stat_holder};
        }
        Object[] object_args = ((class_2588)((class_2561)messagePacket.getMessages().getFirst()).method_10851()).method_11023();
        block17 : switch (MainActionSplit[2]) {
            case "unboost": 
            case "boost": {
                if (MainActionSplit.length > 3 && Objects.equals(MainActionSplit[3], "cap")) {
                    return new Object[]{current_atk, current_pkm, tmp_stat_holder};
                }
                BattleStateTracker.changeStats(BattleProcess.getPkm(object_args), ((class_2588)((class_5250)object_args[1]).method_10851()).method_11022().split("\\.")[2], MainActionSplit[3], Objects.equals(MainActionSplit[2], "boost"));
                break;
            }
            case "used_move_on": 
            case "used_move": {
                current_pkm = BattleProcess.getPkm(object_args);
                current_atk = ((class_2588)((class_5250)object_args[1]).method_10851()).method_11022().split("\\.")[2];
                break;
            }
            case "switch": {
                String switchedTo;
                if (MainActionSplit[3].equals("self")) {
                    String pokemon = ((class_2588)((class_5250)object_args[0]).method_10851()).method_11022();
                    String owner = class_310.method_1551().field_1724.method_5476().getString();
                    switchedTo = owner + "/" + pokemon;
                } else {
                    switchedTo = String.valueOf(object_args[0]) + "/" + ((class_2588)((class_5250)object_args[1]).method_10851()).method_11022();
                }
                BattleStateTracker.addPokemon(switchedTo);
                if (!Objects.equals(current_atk, "batonpass") || tmp_stat_holder == null) break;
                BattleStateTracker.applyStats(switchedTo, tmp_stat_holder);
                tmp_stat_holder = null;
                current_atk = "";
                break;
            }
            case "start": {
                switch (MainActionSplit[3]) {
                    case "typechange": {
                        BattleStateTracker.getPokemon(BattleProcess.getPkm(object_args)).overrideType(object_args[1].toString());
                        break block17;
                    }
                    case "typeadd": {
                        BattleStateTracker.getPokemon(BattleProcess.getPkm(object_args)).addType(object_args[1].toString());
                        break block17;
                    }
                }
                BattleStateTracker.getPokemon(BattleProcess.getPkm(object_args)).addExtraEffect(MainActionSplit[3]);
                break;
            }
            case "end": {
                BattleStateTracker.getPokemon(BattleProcess.getPkm(object_args)).removeExtraEffect(MainActionSplit[3]);
                break;
            }
            case "fail": {
                current_atk = "";
                break;
            }
            case "setboost": {
                BattleStateTracker.changeStats(BattleProcess.getPkm(object_args), "attack", "max", true);
                break;
            }
            case "fieldstart": {
                if (MainActionSplit[3].contains("terrain")) {
                    TerrainBattleState.setTerrain(MainActionSplit[3]);
                    break;
                }
                TerrainBattleState.addRoom(MainActionSplit[3]);
                break;
            }
            case "fieldend": {
                if (MainActionSplit[3].contains("terrain")) {
                    TerrainBattleState.setTerrain("");
                    break;
                }
                TerrainBattleState.removeRoom(MainActionSplit[3]);
                break;
            }
            case "sidestart": {
                if (((class_2588)((class_5250)object_args[0]).method_10851()).method_11022().contains("ally")) {
                    TerrainBattleState.addHazard(true, MainActionSplit[3]);
                    break;
                }
                TerrainBattleState.addHazard(false, MainActionSplit[3]);
                break;
            }
            case "sideend": {
                if (((class_2588)((class_5250)object_args[0]).method_10851()).method_11022().contains("ally")) {
                    TerrainBattleState.removeHazard(true, MainActionSplit[3]);
                    break;
                }
                TerrainBattleState.removeHazard(false, MainActionSplit[3]);
                break;
            }
            case "weather": {
                if (Objects.equals(MainActionSplit[4], "start")) {
                    TerrainBattleState.setWeather(MainActionSplit[3]);
                    break;
                }
                if (!Objects.equals(MainActionSplit[4], "end")) break;
                TerrainBattleState.setWeather("");
                break;
            }
            case "turn": {
                TerrainBattleState.updateRoom();
                TerrainBattleState.updateTerrain();
                TerrainBattleState.updateWeather();
                break;
            }
        }
        if (Objects.equals(current_atk, "batonpass") && tmp_stat_holder == null) {
            tmp_stat_holder = BattleStateTracker.getStatsForHold(current_pkm);
        }
        return new Object[]{current_atk, current_pkm, tmp_stat_holder};
    }

    private static String getPkm(Object[] target) {
        if (((class_2588)((class_5250)target[0]).method_10851()).method_11022().contains("species")) {
            return ((class_2588)((class_5250)target[0]).method_10851()).method_11022();
        }
        Object[] data = ((class_2588)((class_5250)target[0]).method_10851()).method_11023();
        String pokemon = ((class_2588)((class_5250)data[1]).method_10851()).method_11022();
        return String.valueOf(data[0]) + "/" + pokemon;
    }

    private static int drawStats(class_332 ctx, class_327 font, String text, int x, int y, float scale, int color) {
        int margin = 1;
        int n = x + (int)((float)font.method_1727(text) * scale) + margin;
        Objects.requireNonNull(font);
        ctx.method_25294(x - margin, y - margin, n, y + (int)(9.0f * scale) + margin, -2003989107);
        int n2 = (int)((float)font.method_1727(text) * scale) + margin * 4;
        Objects.requireNonNull(font);
        ctx.method_49601(x - margin * 2, y - margin * 2, n2, (int)(9.0f * scale) + margin * 4, -13684945);
        ctx.method_51448().method_22903();
        ctx.method_51448().method_46416((float)x, (float)y, 0.0f);
        ctx.method_51448().method_22905(scale, scale, 0.0f);
        ctx.method_51433(font, text, 0, 0, color, true);
        ctx.method_51448().method_22909();
        return x + (int)((float)font.method_1727(text) * scale) + margin;
    }
}

