/*
 * Decompiled with CFR 0.152.
 */
package io.github.flo12344.cobblestats.common.client;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.minecraft.class_2588;
import net.minecraft.class_5250;
import net.minecraft.class_7417;

public class PokemonBattleState {
    private final Map<String, Integer> states = new HashMap<String, Integer>();
    private final Set<String> typesAdded = new HashSet<String>();
    private final Set<String> extraEffects = new HashSet<String>();
    private final Map<String, Integer> turnBasedffects = new HashMap<String, Integer>();
    private String typeOverride = "";

    public void boostState(String stat, String severity, boolean isBoost) {
        int current = this.states.getOrDefault(stat, 0);
        int newStage = Math.max(-6, Math.min(6, current + (isBoost ? this.intSeverity(severity) : -this.intSeverity(severity).intValue())));
        this.states.put(stat, newStage);
        this.checkForZero();
    }

    public void addType(String type) {
        this.typesAdded.add(type);
    }

    public void overrideType(String type) {
        this.typesAdded.clear();
        this.typeOverride = type;
    }

    public void addExtraEffect(String effect) {
        this.extraEffects.add(effect);
    }

    public void removeExtraEffect(String effect) {
        this.extraEffects.remove(effect);
    }

    public void checkForZero() {
        ArrayList keysToRemove = new ArrayList();
        this.states.forEach((s, integer) -> {
            if (integer == 0) {
                keysToRemove.add(s);
            }
        });
        keysToRemove.forEach(this.states::remove);
    }

    public void printAll() {
        this.states.forEach((s, integer) -> System.out.println("    |" + s + " : " + integer));
    }

    public List<String> getStats() {
        ArrayList<String> result = new ArrayList<String>();
        if (!Objects.equals(this.typeOverride, "")) {
            result.add(this.typeOverride);
        }
        if (!this.typesAdded.isEmpty()) {
            this.typesAdded.forEach(s -> result.add("+" + s));
        }
        if (!this.extraEffects.isEmpty()) {
            this.extraEffects.forEach(s -> {
                class_2588 translatableContents = new class_2588("cobblemon.move." + s, null, new Object[0]);
                class_5250 component = class_5250.method_43477((class_7417)translatableContents);
                result.add(component.getString());
            });
        }
        this.states.forEach((s, integer) -> result.add(s + " " + this.statToString((String)s, (Integer)integer)));
        return result;
    }

    private Integer intSeverity(String severity) {
        switch (severity) {
            case "slight": {
                return 1;
            }
            case "sharp": {
                return 2;
            }
            case "severe": {
                return 3;
            }
            case "max": {
                return 12;
            }
        }
        return 0;
    }

    private String statToString(String stat, Integer value) {
        return switch (stat) {
            case "accuracy" -> {
                switch (value) {
                    case -6: {
                        yield "0.333x";
                    }
                    case -5: {
                        yield "0.375x";
                    }
                    case -4: {
                        yield "0.429x";
                    }
                    case -3: {
                        yield "0.5x";
                    }
                    case -2: {
                        yield "0.6x";
                    }
                    case -1: {
                        yield "0.75x";
                    }
                    case 0: {
                        yield "1x";
                    }
                    case 1: {
                        yield "1.333x";
                    }
                    case 2: {
                        yield "1.667x";
                    }
                    case 3: {
                        yield "2x";
                    }
                    case 4: {
                        yield "2.333x";
                    }
                    case 5: {
                        yield "2.667x";
                    }
                    case 6: {
                        yield "3x";
                    }
                }
                yield "";
            }
            case "evasion" -> {
                switch (value) {
                    case -6: {
                        yield "3x";
                    }
                    case -5: {
                        yield "2.667x";
                    }
                    case -4: {
                        yield "2.333x";
                    }
                    case -3: {
                        yield "2x";
                    }
                    case -2: {
                        yield "1.667x";
                    }
                    case -1: {
                        yield "1.333x";
                    }
                    case 0: {
                        yield "1x";
                    }
                    case 1: {
                        yield "0.75x";
                    }
                    case 2: {
                        yield "0.6x";
                    }
                    case 3: {
                        yield "0.5x";
                    }
                    case 4: {
                        yield "0.429x";
                    }
                    case 5: {
                        yield "0.375x";
                    }
                    case 6: {
                        yield "0.333x";
                    }
                }
                yield "";
            }
            default -> {
                switch (value) {
                    case -6: {
                        yield "0.25x";
                    }
                    case -5: {
                        yield "0.2857x";
                    }
                    case -4: {
                        yield "0.333x";
                    }
                    case -3: {
                        yield "0.4x";
                    }
                    case -2: {
                        yield "0.5x";
                    }
                    case -1: {
                        yield "0.667x";
                    }
                    case 0: {
                        yield "1x";
                    }
                    case 1: {
                        yield "1.5x";
                    }
                    case 2: {
                        yield "2x";
                    }
                    case 3: {
                        yield "2.5x";
                    }
                    case 4: {
                        yield "3x";
                    }
                    case 5: {
                        yield "3.5x";
                    }
                    case 6: {
                        yield "4x";
                    }
                }
                yield "";
            }
        };
    }
}

