/*
 * Decompiled with CFR 0.152.
 */
package io.github.flo12344.cobblestats.common.client;

import com.cobblemon.mod.common.api.battles.model.actor.ActorType;
import com.cobblemon.mod.common.api.gui.GuiUtilsKt;
import com.cobblemon.mod.common.client.CobblemonClient;
import com.cobblemon.mod.common.client.battle.ActiveClientBattlePokemon;
import com.cobblemon.mod.common.client.battle.ClientBattle;
import com.cobblemon.mod.common.client.battle.ClientBattlePokemon;
import com.cobblemon.mod.common.net.messages.client.battle.BattleInitializePacket;
import com.mojang.blaze3d.vertex.PoseStack;
import io.github.flo12344.cobblestats.common.client.BattleStateTracker;
import io.github.flo12344.cobblestats.common.client.PokemonBattleState;
import io.github.flo12344.cobblestats.common.client.TerrainBattleState;
import io.github.flo12344.cobblestats.common.client.net.ClientData;
import io.github.flo12344.cobblestats.common.utils.PlayerTeamInfo;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.contents.PlainTextContents;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.resources.ResourceLocation;

public class BattleProcess {
    public static int previousCount = 0;
    public static int currentCount = 0;
    public static int sideCount = 0;
    public static boolean side1 = false;
    public static boolean side2 = false;
    private static final int BG = -2003989107;
    private static final int BORDER = -13684945;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void drawUI(GuiGraphics context, ActiveClientBattlePokemon activeBattlePokemon, boolean left, int rank, boolean isHovered, boolean isCompact) {
        Minecraft mc = Minecraft.getInstance();
        ClientBattlePokemon battlePokemon = activeBattlePokemon.getBattlePokemon();
        if (battlePokemon == null) {
            return;
        }
        ClientBattle battle = CobblemonClient.INSTANCE.getBattle();
        if (battle == null) {
            return;
        }
        int playerNumberOffset = (Character.getNumericValue(activeBattlePokemon.getActorShowdownId().charAt(1)) - 1) / 2 * 10;
        float original_Y = 10 + rank * (isCompact ? 30 : 40) + (left ? playerNumberOffset : (battle.getBattleFormat().getBattleType().getActorsPerSide() - 1) * 10 - playerNumberOffset);
        float original_X = activeBattlePokemon.getXDisplacement();
        int portraitOffsetY = isCompact ? 7 : 8;
        int portraitDiameter = isCompact ? 19 : 28;
        int infoOffsetX = isCompact ? 6 : 7;
        original_X += left ? (float)(infoOffsetX + portraitDiameter) : 0.0f;
        original_Y += (float)portraitOffsetY + (float)portraitDiameter * 0.75f;
        ComponentContents value = activeBattlePokemon.getBattlePokemon().getDisplayName().getContents();
        Object key = value instanceof TranslatableContents ? ((TranslatableContents)value).getKey() : ((PlainTextContents.LiteralContents)value).text();
        ComponentContents componentContents = activeBattlePokemon.getBattlePokemon().getActor().getDisplayName().getContents();
        if (componentContents instanceof PlainTextContents.LiteralContents) {
            String text1;
            PlainTextContents.LiteralContents literalContents = (PlainTextContents.LiteralContents)componentContents;
            try {
                String string;
                text1 = string = literalContents.text();
            }
            catch (Throwable throwable) {
                throw new MatchException(throwable.toString(), throwable);
            }
            key = text1 + "/" + (String)key;
        } else {
            TranslatableContents translatableContents;
            componentContents = activeBattlePokemon.getBattlePokemon().getActor().getDisplayName().getContents();
            if (componentContents instanceof TranslatableContents && (!(translatableContents = (TranslatableContents)componentContents).getKey().contains(".") || translatableContents.getKey().contains("trainer"))) {
                key = translatableContents.getKey() + "/" + (String)key;
            }
        }
        List<String> stats = BattleStateTracker.getChangedStats((String)key);
        float maxX = isCompact ? 95.0f : 95.0f;
        float[] x = new float[]{original_X += 5.0f};
        float[] finalOriginal_X = new float[]{original_X};
        if (activeBattlePokemon.getBattlePokemon().getStatus() != null) {
            if (left) {
                x[0] = x[0] + 35.0f;
            } else {
                finalOriginal_X[0] = finalOriginal_X[0] - 35.0f;
            }
        }
        float scale = 0.5f;
        float[] y = new float[]{original_Y};
        stats.forEach(s -> {
            if (x[0] + (float)((int)((float)mc.font.width(s) * 0.5f)) > finalOriginal_X[0] + maxX) {
                x[0] = finalOriginal_X[0];
                float f = y[0];
                Objects.requireNonNull(mc.font);
                y[0] = f + (9.0f * 0.5f + 3.0f);
            }
            x[0] = BattleProcess.drawStats(context, mc.font, s, (int)x[0], (int)y[0], 0.5f, 0xFFFFFF) + 3;
        });
        if (left) {
            int x_pos;
            Object text;
            int[] y_pos = new int[]{10};
            if (!((String)TerrainBattleState.getTerrainState()[0]).isEmpty()) {
                Object[] terrain = TerrainBattleState.getTerrainState();
                text = (String)terrain[0];
                text = (Integer)terrain[1] < 0 ? (String)text + " " + ((Integer)terrain[1] + 3) : (String)text + " " + String.valueOf(terrain[1]) + " or " + ((Integer)terrain[1] + 3);
                x_pos = mc.getWindow().getGuiScaledWidth() / 2 - (int)((float)mc.font.width((String)text) / 2.0f * 0.5f);
                BattleProcess.drawStats(context, mc.font, (String)text, x_pos, y_pos[0], 0.5f, 0xFFFFFF);
                int n = y_pos[0];
                Objects.requireNonNull(mc.font);
                y_pos[0] = n + ((int)(9.0f * 0.5f) + 3);
            }
            TerrainBattleState.getRoomState().forEach((s, integer) -> {
                String text = s + " " + integer;
                int x_pos = mc.getWindow().getGuiScaledWidth() / 2 - (int)((float)mc.font.width(text) / 2.0f * 0.5f);
                BattleProcess.drawStats(context, mc.font, text, x_pos, y_pos[0], 0.5f, 0xFFFFFF);
                int n = y_pos[0];
                Objects.requireNonNull(mc.font);
                y_pos[0] = n + ((int)(9.0f * 0.5f) + 3);
            });
            if (!((String)TerrainBattleState.getWeatherState()[0]).isEmpty()) {
                Object[] weather = TerrainBattleState.getWeatherState();
                text = (String)weather[0];
                text = (Integer)weather[1] < 0 ? (String)text + " " + ((Integer)weather[1] + 3) : (String)text + " " + String.valueOf(weather[1]) + " or " + ((Integer)weather[1] + 3);
                x_pos = mc.getWindow().getGuiScaledWidth() / 2 - (int)((float)mc.font.width((String)text) / 2.0f * 0.5f);
                BattleProcess.drawStats(context, mc.font, (String)text, x_pos, y_pos[0], 0.5f, 0xFFFFFF);
                int n = y_pos[0];
                Objects.requireNonNull(mc.font);
                y_pos[0] = n + ((int)(9.0f * 0.5f) + 3);
            }
        }
        BattleProcess.renderHazard(context, left, isCompact, original_Y, mc, 0.5f);
        if (!ClientData.SERVER_COMPAT) {
            return;
        }
        if (!left && activeBattlePokemon.getActor().getType() == ActorType.WILD) {
            return;
        }
        int pokeballX = 12;
        if (!left) {
            pokeballX = mc.getWindow().getGuiScaledWidth() - pokeballX - (isCompact ? 128 : 140);
        }
        x[0] = pokeballX + battle.getBattleFormat().getBattleType().getSlotsPerActor() + (left ? infoOffsetX + portraitDiameter : 0);
        int _y_pos = 4;
        PoseStack matrix = context.pose();
        matrix.pushPose();
        matrix.translate(x[0], 4.0f, 0.0f);
        float ball_size = 0.45f;
        matrix.scale(ball_size, ball_size, ball_size);
        ClientData.pokemonCounts.forEach((uuid, integer) -> {
            String pokeball = "poke_ball";
            if (activeBattlePokemon.getActor().getUuid().equals(uuid)) {
                int pos = left ? (int)(isCompact ? 128.0f - ball_size * 114.0f : 140.0f - ball_size * 114.0f) : 0;
                List<PlayerTeamInfo.TeamPokemon> team = integer.getTeamPokemons();
                for (int i = 0; i < 6; ++i) {
                    Number color_shift;
                    int margin = 1;
                    if (i < team.size() && team.get(i) != null) {
                        pokeball = team.get((int)i).ball;
                        color_shift = !team.get((int)i).is_ko ? (Number)1 : (Number)0.5;
                    } else {
                        color_shift = 0;
                    }
                    ResourceLocation res = ResourceLocation.fromNamespaceAndPath((String)"cobblemon", (String)("textures/gui/ball/" + pokeball + ".png"));
                    GuiUtilsKt.blitk((PoseStack)matrix, (ResourceLocation)res, (Number)pos, (Number)0, (Number)20, (Number)18, (Number)0, (Number)0, (Number)18, (Number)44, (Number)5, (Number)color_shift, (Number)color_shift, (Number)color_shift, (Number)1);
                    pos += 18 + margin;
                }
            }
        });
        matrix.popPose();
    }

    private static void renderHazard(GuiGraphics context, boolean left, boolean isCompact, float original_Y, Minecraft mc, float scale) {
        int[] _y = new int[]{(int)(original_Y + (float)(isCompact ? 19 : 28))};
        TerrainBattleState.getHazardStates(left).forEach((s, integer) -> {
            Object text = s;
            if (integer > 1) {
                text = (String)text + " " + integer;
            }
            int _x = 10;
            if (!left) {
                _x = mc.getWindow().getGuiScaledWidth() - _x - (int)((float)mc.font.width((String)text) * scale);
            }
            BattleProcess.drawStats(context, mc.font, (String)text, _x, _y[0], scale, 0xFFFFFF);
            int n = _y[0];
            Objects.requireNonNull(mc.font);
            _y[0] = n + ((int)(9.0f * scale) + 3);
        });
    }

    public static Object[] processBattleData(TranslatableContents messagePacket, String current_atk, String current_pkm, PokemonBattleState tmp_stat_holder) {
        String[] MainActionSplit = messagePacket.getKey().split("\\.");
        if (MainActionSplit.length < 3 || !Objects.equals(MainActionSplit[1], "battle")) {
            return new Object[]{current_atk, current_pkm, tmp_stat_holder};
        }
        System.out.println(messagePacket.toString());
        Object[] object_args = messagePacket.getArgs();
        block19 : switch (MainActionSplit[2]) {
            case "unboost": 
            case "boost": {
                if (MainActionSplit.length > 3 && Objects.equals(MainActionSplit[3], "cap")) {
                    return new Object[]{current_atk, current_pkm, tmp_stat_holder};
                }
                BattleStateTracker.changeStats(BattleProcess.getPkm(object_args), ((TranslatableContents)((MutableComponent)object_args[1]).getContents()).getKey().split("\\.")[2], MainActionSplit[3], Objects.equals(MainActionSplit[2], "boost"));
                break;
            }
            case "used_move_on": 
            case "used_move": {
                current_pkm = BattleProcess.getPkm(object_args);
                current_atk = ((TranslatableContents)((MutableComponent)object_args[1]).getContents()).getKey().split("\\.")[2];
                break;
            }
            case "switch": {
                String switchedTo;
                if (MainActionSplit[3].equals("self")) {
                    String pokemon = object_args[0] instanceof MutableComponent ? ((TranslatableContents)((MutableComponent)object_args[0]).getContents()).getKey() : (String)object_args[0];
                    String owner = Minecraft.getInstance().player.getDisplayName().getString();
                    switchedTo = owner + "/" + pokemon;
                } else {
                    String pokemon = object_args[1] instanceof MutableComponent ? ((TranslatableContents)((MutableComponent)object_args[1]).getContents()).getKey() : (String)object_args[1];
                    String owner = object_args[0] instanceof MutableComponent ? ((TranslatableContents)((MutableComponent)object_args[0]).getContents()).getKey() : object_args[0].toString();
                    switchedTo = owner + "/" + pokemon;
                }
                BattleStateTracker.addPokemon(switchedTo);
                if (!Objects.equals(current_atk, "batonpass") || tmp_stat_holder == null) break;
                BattleStateTracker.applyStats(switchedTo, tmp_stat_holder);
                tmp_stat_holder = null;
                current_atk = "";
                break;
            }
            case "withdraw": {
                String toRemove;
                if (MainActionSplit[3].equals("self")) {
                    String pokemon = object_args[0] instanceof MutableComponent ? ((TranslatableContents)((MutableComponent)object_args[0]).getContents()).getKey() : (String)object_args[0];
                    String owner = Minecraft.getInstance().player.getDisplayName().getString();
                    toRemove = owner + "/" + pokemon;
                } else {
                    String pokemon = object_args[1] instanceof MutableComponent ? ((TranslatableContents)((MutableComponent)object_args[1]).getContents()).getKey() : (String)object_args[1];
                    String owner = object_args[0] instanceof MutableComponent ? ((TranslatableContents)((MutableComponent)object_args[0]).getContents()).getKey() : object_args[0].toString();
                    toRemove = owner + "/" + pokemon;
                }
                BattleStateTracker.removePokemon(toRemove);
                break;
            }
            case "start": {
                switch (MainActionSplit[3]) {
                    case "typechange": {
                        BattleStateTracker.getPokemon(BattleProcess.getPkm(object_args)).overrideType(object_args[1].toString());
                        break block19;
                    }
                    case "typeadd": {
                        BattleStateTracker.getPokemon(BattleProcess.getPkm(object_args)).addType(object_args[1].toString());
                        break block19;
                    }
                }
                BattleStateTracker.getPokemon(BattleProcess.getPkm(object_args)).addExtraEffect(MainActionSplit[3]);
                break;
            }
            case "end": {
                BattleStateTracker.getPokemon(BattleProcess.getPkm(object_args)).removeExtraEffect(MainActionSplit[3]);
                break;
            }
            case "fail": {
                current_atk = "";
                break;
            }
            case "setboost": {
                BattleStateTracker.changeStats(BattleProcess.getPkm(object_args), "attack", "max", true);
                break;
            }
            case "fieldstart": {
                if (MainActionSplit[3].contains("terrain")) {
                    TerrainBattleState.setTerrain(MainActionSplit[3]);
                    break;
                }
                TerrainBattleState.addRoom(MainActionSplit[3]);
                break;
            }
            case "fieldend": {
                if (MainActionSplit[3].contains("terrain")) {
                    TerrainBattleState.setTerrain("");
                    break;
                }
                TerrainBattleState.removeRoom(MainActionSplit[3]);
                break;
            }
            case "sidestart": {
                if (MainActionSplit.length == 5) {
                    if (MainActionSplit[3].equals("opponent")) {
                        TerrainBattleState.addHazard(false, MainActionSplit[4]);
                        break;
                    }
                    TerrainBattleState.addHazard(true, MainActionSplit[4]);
                    break;
                }
                if (((TranslatableContents)((MutableComponent)object_args[0]).getContents()).getKey().contains("ally")) {
                    TerrainBattleState.addHazard(true, MainActionSplit[3]);
                    break;
                }
                TerrainBattleState.addHazard(false, MainActionSplit[3]);
                break;
            }
            case "sideend": {
                if (MainActionSplit.length == 5) {
                    if (MainActionSplit[3].equals("opponent")) {
                        TerrainBattleState.removeHazard(false, MainActionSplit[4]);
                        break;
                    }
                    TerrainBattleState.removeHazard(true, MainActionSplit[4]);
                    break;
                }
                if (((TranslatableContents)((MutableComponent)object_args[0]).getContents()).getKey().contains("ally")) {
                    TerrainBattleState.removeHazard(true, MainActionSplit[3]);
                    break;
                }
                TerrainBattleState.removeHazard(false, MainActionSplit[3]);
                break;
            }
            case "weather": {
                if (Objects.equals(MainActionSplit[4], "start")) {
                    TerrainBattleState.setWeather(MainActionSplit[3]);
                    break;
                }
                if (!Objects.equals(MainActionSplit[4], "end")) break;
                TerrainBattleState.setWeather("");
                break;
            }
            case "turn": {
                TerrainBattleState.updateRoom();
                TerrainBattleState.updateTerrain();
                TerrainBattleState.updateWeather();
                break;
            }
            case "fainted": {
                BattleStateTracker.removePokemon(BattleProcess.getPkm(object_args));
                break;
            }
        }
        if (Objects.equals(current_atk, "batonpass") && tmp_stat_holder == null) {
            tmp_stat_holder = BattleStateTracker.getStatsForHold(current_pkm);
        }
        return new Object[]{current_atk, current_pkm, tmp_stat_holder};
    }

    private static String getPkm(Object[] target) {
        if (((TranslatableContents)((MutableComponent)target[0]).getContents()).getKey().contains("species")) {
            return ((TranslatableContents)((MutableComponent)target[0]).getContents()).getKey();
        }
        Object[] data = ((TranslatableContents)((MutableComponent)target[0]).getContents()).getArgs();
        String pokemon = data[1] instanceof MutableComponent ? ((TranslatableContents)((MutableComponent)data[1]).getContents()).getKey() : data[1].toString();
        String owner = data[0] instanceof MutableComponent ? ((TranslatableContents)((MutableComponent)data[0]).getContents()).getKey() : data[0].toString();
        return owner + "/" + pokemon;
    }

    private static int drawStats(GuiGraphics ctx, Font font, String text, int x, int y, float scale, int color) {
        int margin = 1;
        int n = x + (int)((float)font.width(text) * scale) + margin;
        Objects.requireNonNull(font);
        ctx.fill(x - margin, y - margin, n, y + (int)(9.0f * scale) + margin, -2003989107);
        int n2 = (int)((float)font.width(text) * scale) + margin * 4;
        Objects.requireNonNull(font);
        ctx.renderOutline(x - margin * 2, y - margin * 2, n2, (int)(9.0f * scale) + margin * 4, -13684945);
        ctx.pose().pushPose();
        ctx.pose().translate((float)x, (float)y, 0.0f);
        ctx.pose().scale(scale, scale, 0.0f);
        ctx.drawString(font, text, 0, 0, color, true);
        ctx.pose().popPose();
        return x + (int)((float)font.width(text) * scale) + margin;
    }

    public static void checkSide(BattleInitializePacket.BattleSideDTO side) {
        if (!((BattleInitializePacket.BattleActorDTO)side.component1().getFirst()).getActivePokemon().isEmpty()) {
            ((BattleInitializePacket.BattleActorDTO)side.component1().getFirst()).getActivePokemon().forEach(activeBattlePokemonDTO -> {
                if (activeBattlePokemonDTO == null) {
                    return;
                }
                if (((BattleInitializePacket.BattleActorDTO)side.component1().getFirst()).getType() == ActorType.PLAYER) {
                    BattleStateTracker.addPokemon(((BattleInitializePacket.BattleActorDTO)side.component1().getFirst()).getDisplayName().getString() + "/" + ((TranslatableContents)activeBattlePokemonDTO.getDisplayName().getContents()).getKey());
                } else if (((BattleInitializePacket.BattleActorDTO)side.component1().getFirst()).getType() == ActorType.NPC) {
                    BattleStateTracker.addPokemon(String.valueOf(((BattleInitializePacket.BattleActorDTO)side.component1().getFirst()).getDisplayName()) + "/" + ((TranslatableContents)activeBattlePokemonDTO.getDisplayName().getContents()).getKey());
                } else {
                    BattleStateTracker.addPokemon(((TranslatableContents)activeBattlePokemonDTO.getDisplayName().getContents()).getKey());
                }
            });
        }
    }
}

