/*
 * Decompiled with CFR 0.152.
 */
package io.github.flo12344.cobblestats.mixin.server;

import com.cobblemon.mod.common.api.battles.interpreter.BattleMessage;
import com.cobblemon.mod.common.api.battles.model.PokemonBattle;
import com.cobblemon.mod.common.api.battles.model.actor.BattleActor;
import io.github.flo12344.cobblestats.common.net.ServerData;
import io.github.flo12344.cobblestats.common.net.payload.FaintOrRevivePayload;
import io.github.flo12344.cobblestats.common.utils.PlatformNetwork;
import java.util.ArrayList;
import java.util.UUID;
import net.minecraft.server.MinecraftServer;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(targets={"com/cobblemon/mod/common/battles/interpreter/instructions/HealInstruction"})
public class CSHealInstructionMixin {
    @Shadow
    private BattleMessage privateMessage;
    @Shadow
    private BattleActor actor;

    @Inject(method={"invoke(Lcom/cobblemon/mod/common/api/battles/model/PokemonBattle;)V"}, at={@At(value="TAIL")})
    public void invoke(PokemonBattle battle, CallbackInfo ci) {
        if (this.privateMessage.getRawMessage().endsWith("revive")) {
            UUID uuid = UUID.fromString(this.privateMessage.argumentAt(0).split(":")[1].trim());
            int[] id = new int[]{0};
            this.actor.getPokemonList().forEach(battlePokemon -> {
                if (battlePokemon.getUuid().equals(uuid)) {
                    id[0] = ServerData.startTeams.get(this.actor.getUuid()).indexOf(battlePokemon);
                }
            });
            ArrayList players = new ArrayList();
            battle.getActors().forEach(serverPlayer -> players.add(serverPlayer.getUuid()));
            MinecraftServer server = PlatformNetwork.INSTANCE.getCurrentServer();
            players.forEach(target -> {
                if (ServerData.playerWithMod.contains(target)) {
                    PlatformNetwork.INSTANCE.sendToClient(server.getPlayerList().getPlayer(target), new FaintOrRevivePayload(this.actor.getUuid().toString(), id[0], false));
                }
            });
        }
    }
}

