/*
 * Decompiled with CFR 0.152.
 */
package survivalblock.laseredstone.client.render;

import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.minecraft.class_156;
import net.minecraft.class_1921;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5614;
import net.minecraft.class_7833;
import net.minecraft.class_822;
import net.minecraft.class_9848;
import net.minecraft.class_9974;
import org.apache.commons.lang3.function.Consumers;
import org.joml.Quaternionfc;
import survivalblock.laseredstone.common.block.entity.LaserBlockEntity;

public class LaserBlockEntityRenderer<T extends LaserBlockEntity>
extends class_822<T> {
    protected static final Map<class_2350, Consumer<class_4587>> DIRECTION_TRANSFORMS = ((ImmutableMap.Builder)class_156.method_654((Object)ImmutableMap.builder(), builder -> {
        builder.put((Object)class_2350.field_11036, (Object)Consumers.nop());
        builder.put((Object)class_2350.field_11033, matrixStack -> matrixStack.method_22907((Quaternionfc)class_7833.field_40714.rotationDegrees(180.0f)));
        builder.put((Object)class_2350.field_11043, matrixStack -> matrixStack.method_22907((Quaternionfc)class_7833.field_40713.rotationDegrees(90.0f)));
        builder.put((Object)class_2350.field_11035, matrixStack -> matrixStack.method_22907((Quaternionfc)class_7833.field_40714.rotationDegrees(90.0f)));
        builder.put((Object)class_2350.field_11034, matrixStack -> matrixStack.method_22907((Quaternionfc)class_7833.field_40717.rotationDegrees(90.0f)));
        builder.put((Object)class_2350.field_11039, matrixStack -> matrixStack.method_22907((Quaternionfc)class_7833.field_40718.rotationDegrees(90.0f)));
    })).build();

    public LaserBlockEntityRenderer(class_5614.class_5615 ctx) {
        super(ctx);
    }

    public void render(T laser, float tickProgress, class_4587 matrices, class_4597 vertexConsumers, int light, int overlay, class_243 cameraPos) {
        Map<class_2350, Integer> directionToDistanceMap = ((LaserBlockEntity)((Object)laser)).getDirectionToDistanceMap();
        if (directionToDistanceMap.isEmpty()) {
            return;
        }
        Map<class_2350, List> directionToSegmentsMap = directionToDistanceMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> laser.getBeamSegments((class_2350)entry.getKey(), (Integer)entry.getValue())));
        for (Map.Entry<class_2350, Integer> entry2 : directionToDistanceMap.entrySet()) {
            class_2350 output = entry2.getKey();
            matrices.method_22903();
            matrices.method_22904(0.5, 0.5, 0.5);
            DIRECTION_TRANSFORMS.get(output).accept(matrices);
            matrices.method_22904(-0.5, -0.5, -0.5);
            ((LaserBlockEntity)((Object)laser)).setRenderingSegments(directionToSegmentsMap.get(output));
            super.method_3569(laser, tickProgress, matrices, vertexConsumers, light, overlay, cameraPos);
            ((LaserBlockEntity)((Object)laser)).setRenderingSegments(null);
            matrices.method_22909();
            if (!((LaserBlockEntity)((Object)laser)).isOvercharged() || !class_310.method_1551().method_1561().method_3958()) continue;
            class_2338 blockPos = laser.method_11016();
            class_243 center = blockPos.method_46558();
            class_238 box = LaserBlockEntity.expandInOneDirection(new class_238(center.method_61888(0.125), center.method_61889(0.125)), class_243.method_24954((class_2382)output.method_62675()).method_1021((double)entry2.getValue().intValue() + 0.375));
            matrices.method_22903();
            matrices.method_46416((float)(-blockPos.method_10263()), (float)(-blockPos.method_10264()), (float)(-blockPos.method_10260()));
            int color = ((LaserBlockEntity)((Object)laser)).getColor();
            float red = class_9848.method_65101((int)color);
            float green = class_9848.method_65102((int)color);
            float blue = class_9848.method_65103((int)color);
            class_9974.method_62295((class_4587)matrices, (class_4588)vertexConsumers.getBuffer((class_1921)class_1921.field_21695), (class_238)box, (float)red, (float)green, (float)blue, (float)1.0f);
            matrices.method_22909();
        }
    }
}

