/*
 * Decompiled with CFR 0.152.
 */
package survivalblock.laseredstone.common.block.entity;

import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.class_10633;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_2390;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_7225;
import net.minecraft.class_9282;
import net.minecraft.class_9323;
import net.minecraft.class_9334;
import net.minecraft.class_9473;
import net.minecraft.class_9848;
import org.jetbrains.annotations.Nullable;
import survivalblock.laseredstone.common.block.LaserBlock;
import survivalblock.laseredstone.common.block.entity.LaserInteractorBlockEntity;
import survivalblock.laseredstone.common.init.LaseredstoneBlockEntityTypes;
import survivalblock.laseredstone.common.init.LaseredstoneTags;
import survivalblock.laseredstone.common.world.DelayedDamager;
import survivalblock.laseredstone.mixin.BeamEmitterMixin;

public class LaserBlockEntity
extends LaserInteractorBlockEntity
implements class_10633 {
    public static final int DEFAULT_COLOR = -1;
    public static final class_9282 DEFAULT_DYE_COMPONENT = new class_9282(-1);
    public static final int MAX_DISTANCE = 16;
    public static final int DEFAULT_DISTANCE = -1;
    protected int distance = -1;
    protected int color = -1;
    protected boolean updateRequired;
    @Nullable
    protected class_2350 currentOutputDirection = null;

    public LaserBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
    }

    public LaserBlockEntity(class_2338 pos, class_2680 state) {
        this(LaseredstoneBlockEntityTypes.LASER, pos, state);
    }

    protected void method_11007(class_11372 view) {
        super.method_11007(view);
        view.method_71465("color", this.color);
    }

    protected void method_11014(class_11368 view) {
        super.method_11014(view);
        this.color = view.method_71424("color", -1);
    }

    public void updateLaser() {
        this.updateRequired = true;
    }

    public boolean canLaser(class_1937 world, class_2338 blockPos, class_2680 blockState) {
        boolean statePowered = (Boolean)blockState.method_11654((class_2769)LaserBlock.POWERED);
        if (!this.updateRequired) {
            return statePowered;
        }
        this.updateRequired = false;
        boolean powered = world.method_49803(blockPos);
        if (powered != statePowered) {
            world.method_8652(blockPos, (class_2680)blockState.method_11657((class_2769)LaserBlock.POWERED, (Comparable)Boolean.valueOf(powered)), 2);
        }
        return powered;
    }

    @Override
    public boolean receiveLaser(class_2350 inputDirection, class_1937 world, class_2338 blockPos, class_2680 blockState, LaserBlockEntity sender) {
        if (!world.method_8608()) {
            class_243 explosion = blockPos.method_46558();
            world.method_22352(blockPos, false);
            world.method_8437(null, explosion.field_1352, explosion.field_1351, explosion.field_1350, 6.0f, class_1937.class_7867.field_40888);
        }
        return false;
    }

    public class_2350 getOutputDirection(class_1937 world, class_2338 blockPos, class_2680 blockState) {
        return (class_2350)blockState.method_11654(LaserBlock.FACING);
    }

    public static <T extends LaserBlockEntity> void tick(class_1937 world, class_2338 blockPos, class_2680 blockState, T blockEntity) {
        blockEntity.tick(world, blockPos, blockState);
    }

    public void tick(class_1937 world, class_2338 blockPos, class_2680 blockState) {
        this.tickLaser(world, blockPos, blockState, () -> this.getOutputDirection(world, blockPos, blockState));
    }

    protected final void tickLaser(class_1937 world, class_2338 blockPos, class_2680 blockState, Supplier<class_2350> direction) {
        if (!this.canLaser(world, blockPos, blockState)) {
            if (this.distance > -1) {
                this.spawnDustParticles(world, blockPos);
            }
            this.distance = -1;
            this.currentOutputDirection = null;
            return;
        }
        boolean wasOff = this.distance == -1;
        this.currentOutputDirection = direction.get();
        class_2382 vec3i = this.currentOutputDirection.method_62675();
        for (int i = 1; i <= 16; ++i) {
            this.distance = i - 1;
            class_2338 mirrorPos = blockPos.method_10081(vec3i.method_35862(i));
            class_2680 mirrorState = world.method_8320(mirrorPos);
            if (mirrorState.method_26164(LaseredstoneTags.ALWAYS_DENIES_LASERS)) break;
            class_2586 class_25862 = world.method_8321(mirrorPos);
            if (class_25862 instanceof LaserInteractorBlockEntity) {
                LaserInteractorBlockEntity interactor = (LaserInteractorBlockEntity)class_25862;
                if (!interactor.receiveLaser(this.currentOutputDirection, world, mirrorPos, mirrorState, this)) break;
                ++this.distance;
                break;
            }
            if (mirrorState.method_26193() >= 15 && !mirrorState.method_26164(LaseredstoneTags.ALWAYS_ALLOWS_LASERS)) break;
        }
        if (wasOff) {
            this.spawnDustParticles(world, blockPos);
        }
        if (this.isOvercharged() && !world.method_8608()) {
            class_243 center = blockPos.method_46558();
            class_238 box = LaserBlockEntity.expandInOneDirection(new class_238(center.method_61888(0.125), center.method_61889(0.125)), class_243.method_24954((class_2382)vec3i).method_1021((double)this.distance + 0.375));
            DelayedDamager.submitDamagingBox(box);
        }
    }

    public static float getDamage(class_1297 entity) {
        float f;
        if (entity instanceof class_1309) {
            class_1309 living = (class_1309)entity;
            f = LaserBlockEntity.getLivingDamage(living);
        } else {
            f = 2.0f;
        }
        return f;
    }

    public static float getLivingDamage(class_1309 living) {
        return Math.max(2.0f, (living.method_6063() + living.method_6067()) * 0.25f);
    }

    public static class_238 expandInOneDirection(class_238 box, class_243 vec3d) {
        double x = vec3d.method_10216();
        double y = vec3d.method_10214();
        double z = vec3d.method_10215();
        if (x > 0.0) {
            box = box.method_35577(box.field_1320 + x);
        } else if (x < 0.0) {
            box = box.method_35574(box.field_1323 + x);
        }
        if (y > 0.0) {
            box = box.method_35578(box.field_1325 + y);
        } else if (y < 0.0) {
            box = box.method_35575(box.field_1322 + y);
        }
        if (z > 0.0) {
            box = box.method_35579(box.field_1324 + z);
        } else if (z < 0.0) {
            box = box.method_35576(box.field_1321 + z);
        }
        return box;
    }

    public void spawnDustParticles(class_1937 world, class_2338 blockPos) {
        if (!world.method_8608()) {
            return;
        }
        if (this.currentOutputDirection == null) {
            return;
        }
        if (this.distance <= -1) {
            return;
        }
        class_2382 vec3i = this.currentOutputDirection.method_62675();
        for (int i = 1; i <= this.distance; ++i) {
            class_2338 pos = blockPos.method_10081(vec3i.method_35862(i));
            class_243 vec3d = pos.method_46558();
            world.method_8406((class_2394)new class_2390(this.color, 1.0f), vec3d.method_10216(), vec3d.method_10214(), vec3d.method_10215(), 0.0, 0.0, 0.0);
        }
    }

    @Nullable
    public Object getRenderData() {
        return this.color;
    }

    @Nullable
    public Object superGetRenderData() {
        return super.getRenderData();
    }

    @Nullable
    public class_2596<class_2602> method_38235() {
        return class_2622.method_38585((class_2586)this);
    }

    public class_2487 method_16887(class_7225.class_7874 registries) {
        return this.method_38244(registries);
    }

    public boolean shouldSaveColor() {
        return true;
    }

    protected void method_57567(class_9323.class_9324 builder) {
        if (this.shouldSaveColor()) {
            builder.method_57840(class_9334.field_49644, (Object)new class_9282(class_9848.method_61335((int)this.color)));
        }
    }

    protected void method_57568(class_9473 components) {
        if (this.shouldSaveColor()) {
            this.color = class_9848.method_61334((int)((class_9282)components.method_58695(class_9334.field_49644, (Object)DEFAULT_DYE_COMPONENT)).comp_2384());
        }
    }

    public List<class_10633.class_2581> method_10937() {
        return this.getBeamSegments(this.currentOutputDirection, this.distance);
    }

    public List<class_10633.class_2581> getBeamSegments(class_2350 direction, int distance) {
        if (distance <= -1 || direction == null) {
            return List.of();
        }
        class_10633.class_2581 beam = new class_10633.class_2581(this.color);
        ((BeamEmitterMixin.BeamSegmentMixin)beam).laseredstone$setHeight(distance + 1);
        return List.of(beam);
    }

    public Map<class_2350, Integer> getDirectionToDistanceMap() {
        if (this.currentOutputDirection == null) {
            return ImmutableMap.of();
        }
        return ImmutableMap.of((Object)this.currentOutputDirection, (Object)this.distance);
    }

    public int getColor() {
        return this.color;
    }

    public void setOvercharged(boolean overcharged) {
    }

    public boolean isOvercharged() {
        return false;
    }
}

