/*
 * Decompiled with CFR 0.152.
 */
package survivalblock.laseredstone.common.block.entity;

import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import org.jetbrains.annotations.Nullable;
import survivalblock.laseredstone.common.block.entity.LaserBlockEntity;

public abstract class MirrorBlockEntity
extends LaserBlockEntity {
    public static final int MAX_DEFLECTION_TICKS = 2;
    protected int deflectionTicks = 0;
    @Nullable
    protected class_2350 inputDirection = null;

    public MirrorBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
    }

    @Override
    public boolean canLaser(class_1937 world, class_2338 blockPos, class_2680 blockState) {
        return this.deflectionTicks > 0 && this.inputDirection != null;
    }

    @Override
    public void tick(class_1937 world, class_2338 blockPos, class_2680 blockState) {
        this.decrementDeflectionTicks();
        super.tick(world, blockPos, blockState);
    }

    public void decrementDeflectionTicks() {
        if (this.deflectionTicks > 0) {
            --this.deflectionTicks;
            return;
        }
        if (this.inputDirection != null) {
            this.inputDirection = null;
        }
        if (this.deflectionTicks != 0) {
            this.deflectionTicks = 0;
        }
    }

    public abstract boolean isAcceptableDirection(class_2350 var1, class_1937 var2, class_2338 var3, class_2680 var4);

    @Override
    public abstract class_2350 getOutputDirection(class_1937 var1, class_2338 var2, class_2680 var3);

    @Override
    public boolean receiveLaser(class_2350 inputDirection, class_1937 world, class_2338 blockPos, class_2680 blockState, LaserBlockEntity sender) {
        if (!this.isAcceptableDirection(inputDirection, world, blockPos, blockState)) {
            return false;
        }
        if (this.deflectionTicks == 2 && inputDirection != this.inputDirection) {
            super.receiveLaser(inputDirection, world, blockPos, blockState, sender);
            return false;
        }
        this.deflectionTicks = 2;
        this.inputDirection = inputDirection;
        this.color = sender.color;
        this.setOvercharged(sender.isOvercharged());
        return true;
    }

    @Override
    public boolean shouldSaveColor() {
        return false;
    }
}

