/*
 * Decompiled with CFR 0.152.
 */
package survivalblock.laseredstone.client.render;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.class_11631;
import net.minecraft.class_11659;
import net.minecraft.class_11683;
import net.minecraft.class_11950;
import net.minecraft.class_12075;
import net.minecraft.class_156;
import net.minecraft.class_1921;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_5614;
import net.minecraft.class_7833;
import net.minecraft.class_822;
import net.minecraft.class_9848;
import net.minecraft.class_9974;
import org.apache.commons.lang3.function.Consumers;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionfc;
import survivalblock.laseredstone.client.render.state.LaserBlockEntityRenderState;
import survivalblock.laseredstone.common.block.entity.LaserBlockEntity;

public class LaserBlockEntityRenderer<T extends LaserBlockEntity>
extends class_822<T> {
    protected static final Map<class_2350, Consumer<class_4587>> DIRECTION_TRANSFORMS = ((ImmutableMap.Builder)class_156.method_654((Object)ImmutableMap.builder(), builder -> {
        builder.put((Object)class_2350.field_11036, (Object)Consumers.nop());
        builder.put((Object)class_2350.field_11033, matrixStack -> matrixStack.method_22907((Quaternionfc)class_7833.field_40714.rotationDegrees(180.0f)));
        builder.put((Object)class_2350.field_11043, matrixStack -> matrixStack.method_22907((Quaternionfc)class_7833.field_40713.rotationDegrees(90.0f)));
        builder.put((Object)class_2350.field_11035, matrixStack -> matrixStack.method_22907((Quaternionfc)class_7833.field_40714.rotationDegrees(90.0f)));
        builder.put((Object)class_2350.field_11034, matrixStack -> matrixStack.method_22907((Quaternionfc)class_7833.field_40717.rotationDegrees(90.0f)));
        builder.put((Object)class_2350.field_11039, matrixStack -> matrixStack.method_22907((Quaternionfc)class_7833.field_40718.rotationDegrees(90.0f)));
    })).build();

    public LaserBlockEntityRenderer(class_5614.class_5615 ctx) {
    }

    public class_11950 method_74338() {
        return new LaserBlockEntityRenderState();
    }

    public void updateRenderState(T blockEntity, class_11950 beaconBlockEntityRenderState, float tickProgress, class_243 cameraPos, @Nullable class_11683.class_11792 crumblingOverlayCommand) {
        super.method_74341(blockEntity, beaconBlockEntityRenderState, tickProgress, cameraPos, crumblingOverlayCommand);
        if (beaconBlockEntityRenderState instanceof LaserBlockEntityRenderState) {
            LaserBlockEntityRenderState laserState = (LaserBlockEntityRenderState)beaconBlockEntityRenderState;
            LaserBlockEntityRenderer.updateLaserRenderState(blockEntity, laserState, tickProgress, cameraPos);
        }
    }

    public static <T extends LaserBlockEntity> void updateLaserRenderState(T laser, LaserBlockEntityRenderState state, float tickProgress, class_243 cameraPos) {
        state.currentOutputDirection = laser.getCurrentOutputDirection();
        state.overcharged = laser.isOvercharged();
        state.distance = laser.getDistance();
        state.color = laser.getColor();
    }

    public void method_74342(class_11950 blockEntityRenderState, class_4587 matrices, class_11659 queue, class_12075 cameraState) {
        if (!(blockEntityRenderState instanceof LaserBlockEntityRenderState)) {
            return;
        }
        LaserBlockEntityRenderState state = (LaserBlockEntityRenderState)blockEntityRenderState;
        class_2350 output = state.currentOutputDirection;
        if (output == null) {
            return;
        }
        matrices.method_22903();
        matrices.method_22904(0.5, 0.5, 0.5);
        DIRECTION_TRANSFORMS.get(output).accept(matrices);
        matrices.method_22904(-0.5, -0.5, -0.5);
        super.method_74342((class_11950)state, matrices, queue, cameraState);
        matrices.method_22909();
        if (state.overcharged && class_310.method_1551().field_61504.method_72772(class_11631.field_61581)) {
            class_2338 blockPos = state.field_62673;
            class_243 center = blockPos.method_46558();
            class_238 box = LaserBlockEntity.expandInOneDirection(new class_238(center.method_61888(0.125), center.method_61889(0.125)), class_243.method_24954((class_2382)output.method_62675()).method_1021((double)state.distance + 0.375));
            matrices.method_22903();
            matrices.method_46416((float)(-blockPos.method_10263()), (float)(-blockPos.method_10264()), (float)(-blockPos.method_10260()));
            int color = state.color;
            float red = class_9848.method_65101((int)color);
            float green = class_9848.method_65102((int)color);
            float blue = class_9848.method_65103((int)color);
            queue.method_73483(matrices, (class_1921)class_1921.field_21695, (matricesEntry, vertexConsumer) -> class_9974.method_62295((class_4587.class_4665)matricesEntry, (class_4588)vertexConsumer, (class_238)box, (float)red, (float)green, (float)blue, (float)1.0f));
            matrices.method_22909();
        }
    }
}

