/*
 * Decompiled with CFR 0.152.
 */
package survivalblock.laseredstone.common.block.entity;

import java.util.EnumMap;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import survivalblock.laseredstone.common.block.ReceiverBlock;
import survivalblock.laseredstone.common.block.entity.LaserBlockEntity;
import survivalblock.laseredstone.common.block.entity.LaserInteractorBlockEntity;
import survivalblock.laseredstone.common.init.LaseredstoneBlockEntityTypes;

public class ReceiverBlockEntity
extends LaserInteractorBlockEntity {
    public final EnumMap<class_2350, Integer> directionToReceiveTicks = new EnumMap(class_2350.class);
    public boolean mapChanged = false;

    public ReceiverBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
    }

    public ReceiverBlockEntity(class_2338 pos, class_2680 state) {
        this(LaseredstoneBlockEntityTypes.RECEIVER, pos, state);
    }

    @Override
    public boolean receiveLaser(class_2350 inputDirection, class_1937 world, class_2338 blockPos, class_2680 blockState, LaserBlockEntity sender) {
        Integer receiveTicks = this.directionToReceiveTicks.get(inputDirection);
        if (receiveTicks == null || receiveTicks != 2) {
            this.directionToReceiveTicks.put(inputDirection, 2);
            this.mapChanged = true;
        }
        return false;
    }

    public static void tick(class_1937 world, class_2338 blockPos, class_2680 blockState, ReceiverBlockEntity blockEntity) {
        EnumMap<class_2350, Integer> temporary = new EnumMap<class_2350, Integer>(class_2350.class);
        blockEntity.directionToReceiveTicks.forEach((direction, integer) -> {
            if (integer > 0) {
                Integer n = integer;
                integer = integer - 1;
                blockEntity.mapChanged = true;
            } else if (integer != 0) {
                integer = 0;
                blockEntity.mapChanged = true;
            }
            temporary.put((class_2350)direction, (Integer)integer);
        });
        blockEntity.directionToReceiveTicks.putAll(temporary);
        if (world.method_8510() % 200L == 0L) {
            temporary.forEach((direction, integer) -> {
                if (integer == 0) {
                    blockEntity.directionToReceiveTicks.remove(direction);
                }
            });
        }
        if (!blockEntity.mapChanged) {
            return;
        }
        blockEntity.mapChanged = false;
        if (world.method_8608()) {
            return;
        }
        boolean shouldBePowered = false;
        for (class_2350 direction2 : class_2350.values()) {
            Integer receiveTicks = blockEntity.directionToReceiveTicks.get(direction2);
            if (receiveTicks == null || receiveTicks <= 0) continue;
            shouldBePowered = true;
            break;
        }
        if ((Boolean)blockState.method_11654((class_2769)ReceiverBlock.POWERED) != shouldBePowered) {
            blockState = (class_2680)blockState.method_28493((class_2769)ReceiverBlock.POWERED);
            world.method_8652(blockPos, blockState, 3);
        }
        ReceiverBlockEntity.update(world, blockPos, blockState);
    }

    protected static void update(class_1937 world, class_2338 blockPos, class_2680 blockState) {
        class_2248 block = blockState.method_26204();
        for (class_2350 direction : class_2350.values()) {
            world.method_8408(blockPos.method_10093(direction), block);
        }
    }
}

