/*
 * Decompiled with CFR 0.152.
 */
package survivalblock.laseredstone.common.world;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_3218;
import survivalblock.laseredstone.common.block.entity.LaserBlockEntity;
import survivalblock.laseredstone.common.init.LaseredstoneDamageTypes;
import survivalblock.laseredstone.common.init.LaseredstoneGameRules;
import survivalblock.laseredstone.common.init.LaseredstoneTags;

public final class DelayedDamager {
    private static final ThreadLocal<Set<class_238>> damagingBoxes = ThreadLocal.withInitial(HashSet::new);

    private DelayedDamager() {
    }

    public static void submitDamagingBox(class_238 box) {
        damagingBoxes.get().add(box);
    }

    public static void damageTick(class_3218 world) {
        Set<class_238> boxes = damagingBoxes.get();
        if (boxes.isEmpty()) {
            return;
        }
        Collection<class_1297> entities = DelayedDamager.getVulnerableCandidates(world);
        if (entities.isEmpty()) {
            return;
        }
        class_1282 source = new class_1282(LaseredstoneDamageTypes.getFromWorld((class_1937)world, LaseredstoneDamageTypes.LASER));
        class_238[] boxArray = (class_238[])boxes.toArray(class_238[]::new);
        class_238 filter = DelayedDamager.encompassing(boxes);
        boolean multi = world.method_64395().method_8355(LaseredstoneGameRules.MULTI_DAMAGE);
        block0: for (class_1297 entity : entities) {
            class_238 bounding = entity.method_5829();
            if (!bounding.method_994(filter)) continue;
            for (class_238 box : boxArray) {
                if (!bounding.method_994(box)) continue;
                entity.method_64397(world, source, LaserBlockEntity.getDamage(entity));
                if (!multi) continue block0;
            }
        }
        boxes.clear();
    }

    private static class_238 encompassing(Iterable<class_238> boxes) {
        Iterator<class_238> itr = boxes.iterator();
        class_238 first = itr.next();
        if (!itr.hasNext()) {
            return first;
        }
        double minX = first.field_1323;
        double minY = first.field_1322;
        double minZ = first.field_1321;
        double maxX = first.field_1320;
        double maxY = first.field_1325;
        double maxZ = first.field_1324;
        while (itr.hasNext()) {
            class_238 box = itr.next();
            minX = Math.min(minX, box.field_1323);
            minY = Math.min(minY, box.field_1322);
            minZ = Math.min(minZ, box.field_1321);
            maxX = Math.max(maxX, box.field_1320);
            maxY = Math.max(maxY, box.field_1325);
            maxZ = Math.max(maxZ, box.field_1324);
        }
        return new class_238(minX, minY, minZ, maxX, maxY, maxZ);
    }

    private static Collection<class_1297> getVulnerableCandidates(class_3218 world) {
        ArrayList<class_1297> list = new ArrayList<class_1297>();
        for (class_1297 entity : world.method_27909()) {
            if (!DelayedDamager.isVulnerableCandidate(entity)) continue;
            list.add(entity);
        }
        return list;
    }

    public static boolean isVulnerableCandidate(class_1297 entity) {
        return entity != null && !entity.method_5655() && !entity.method_5864().method_20210(LaseredstoneTags.LASER_PROOF) && entity.method_5805();
    }
}

