/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.resourcepackmanager.autohost;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.magmaguy.magmacore.util.Logger;
import com.magmaguy.resourcepackmanager.ResourcePackManager;
import com.magmaguy.resourcepackmanager.config.DataConfig;
import com.magmaguy.resourcepackmanager.config.DefaultConfig;
import com.magmaguy.resourcepackmanager.mixer.Mix;
import com.magmaguy.resourcepackmanager.org.apache.hc.client5.http.classic.methods.HttpPost;
import com.magmaguy.resourcepackmanager.org.apache.hc.client5.http.entity.mime.MultipartEntityBuilder;
import com.magmaguy.resourcepackmanager.org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import com.magmaguy.resourcepackmanager.org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import com.magmaguy.resourcepackmanager.org.apache.hc.client5.http.impl.classic.HttpClients;
import com.magmaguy.resourcepackmanager.org.apache.hc.core5.http.ContentType;
import com.magmaguy.resourcepackmanager.org.apache.hc.core5.http.HttpEntity;
import com.magmaguy.resourcepackmanager.org.apache.hc.core5.http.io.entity.EntityUtils;
import com.magmaguy.resourcepackmanager.utils.ServerVersionHelper;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.UUID;
import lombok.Generated;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;

public class AutoHost {
    private static final String finalURL = "https://magmaguy.com/rsp/";
    private static final UUID RESOURCE_PACK_UUID = UUID.fromString("a1b2c3d4-e5f6-4a5b-8c9d-0e1f2a3b4c5d");
    private static boolean done = false;
    private static BukkitTask keepAlive = null;
    private static String rspUUID = null;
    private static boolean firstUpload = true;

    private AutoHost() {
    }

    public static void sendResourcePack(Player player) {
        Logger.info("Sending resource pack to " + player.getName() + ". rspUUID is null: " + (rspUUID == null) + ". done: " + done + ". firstUpload: " + firstUpload + ".");
        if (rspUUID == null || !done) {
            return;
        }
        Logger.info("Sending resource pack to " + player.getName());
        String url = finalURL + rspUUID;
        byte[] hash = Mix.getFinalSHA1Bytes();
        String prompt = DefaultConfig.getResourcePackPrompt();
        boolean force = DefaultConfig.isForceResourcePack();
        if (ServerVersionHelper.supportsMultipleResourcePacks()) {
            player.addResourcePack(RESOURCE_PACK_UUID, url, hash, prompt, force);
        } else {
            player.setResourcePack(url, hash, prompt, force);
        }
    }

    public static void initialize() {
        if (!DefaultConfig.isAutoHost()) {
            return;
        }
        if (Mix.getFinalResourcePack() == null) {
            return;
        }
        Logger.info("Starting autohost!");
        firstUpload = true;
        done = false;
        rspUUID = null;
        if (keepAlive != null) {
            keepAlive.cancel();
        }
        keepAlive = new BukkitRunnable(){
            int counter = 0;

            public void run() {
                if (rspUUID != null) {
                    this.counter = 0;
                    try {
                        AutoHost.sendStillAlive();
                    }
                    catch (Exception e) {
                        rspUUID = null;
                        Logger.warn("Failed to autohost resource pack!");
                        e.printStackTrace();
                    }
                } else {
                    AutoHost.checkFileExistence();
                    if (rspUUID == null && this.counter % 10 == 0) {
                        Logger.warn("Failed to connect to remote server to autohost the resource pack!");
                    }
                    ++this.counter;
                }
            }
        }.runTaskTimerAsynchronously((Plugin)ResourcePackManager.plugin, 0L, 432000L);
    }

    private static void checkFileExistence() {
        AutoHost.initializeLink();
        if (rspUUID == null) {
            Logger.info("No resource pack found on the server! Uploading resource pack to the server...");
            return;
        }
        if (!AutoHost.sendSHA1()) {
            AutoHost.uploadFile();
        } else {
            done = true;
            if (firstUpload) {
                for (Player player : Bukkit.getOnlinePlayers()) {
                    AutoHost.sendResourcePack(player);
                }
            }
            firstUpload = false;
        }
    }

    public static void initializeLink() {
        block21: {
            try (CloseableHttpClient httpClient = HttpClients.createDefault();){
                HttpPost httpPost = new HttpPost("https://magmaguy.com/rsp/initialize");
                MultipartEntityBuilder builder = MultipartEntityBuilder.create();
                builder.addTextBody("uuid", DataConfig.getRspUUID(), ContentType.TEXT_PLAIN.withCharset(StandardCharsets.UTF_8));
                httpPost.setEntity(builder.build());
                try (CloseableHttpResponse response = httpClient.execute(httpPost);){
                    String responseString = EntityUtils.toString(response.getEntity());
                    int statusCode = response.getCode();
                    if (statusCode >= 200 && statusCode < 300) {
                        try {
                            Gson gson = new Gson();
                            JsonObject jsonResponse = gson.fromJson(responseString, JsonObject.class);
                            if (jsonResponse.has("success") && jsonResponse.get("success").getAsBoolean()) {
                                rspUUID = jsonResponse.get("uuid").getAsString();
                                DataConfig.setRspUUID(rspUUID);
                                Logger.info("Server initialized successfully: " + jsonResponse.get("message").getAsString());
                                break block21;
                            }
                            Logger.warn("Server returned error in response: " + responseString);
                            rspUUID = null;
                        }
                        catch (Exception e) {
                            String trimmedResponse = responseString.trim();
                            if (AutoHost.isValidUUID(trimmedResponse)) {
                                rspUUID = trimmedResponse;
                                DataConfig.setRspUUID(rspUUID);
                                Logger.info("Server initialized with UUID: " + rspUUID);
                                break block21;
                            }
                            Logger.warn("Invalid response format from server: " + responseString);
                            rspUUID = null;
                        }
                        break block21;
                    }
                    AutoHost.handleErrorResponse(responseString, statusCode, "initialization");
                    rspUUID = null;
                }
                catch (Exception e) {
                    Logger.warn("Failed to communicate with remote server!");
                    e.printStackTrace();
                    rspUUID = null;
                }
            }
            catch (Exception e) {
                rspUUID = null;
                Logger.warn("Failed remote server initialization.");
                e.printStackTrace();
            }
        }
    }

    private static boolean isValidUUID(String uuidString) {
        if (uuidString == null || uuidString.isEmpty()) {
            return false;
        }
        String cleanUuid = uuidString.replaceAll("-", "");
        if (cleanUuid.length() != 32) {
            return false;
        }
        return cleanUuid.matches("[0-9a-fA-F]+");
    }

    public static void uploadFile() {
        Logger.info("Uploading resource!");
        try (CloseableHttpClient httpClient = HttpClients.createDefault();){
            HttpPost uploadFile = new HttpPost("https://magmaguy.com/rsp/upload");
            MultipartEntityBuilder builder = MultipartEntityBuilder.create();
            builder.addTextBody("uuid", rspUUID, ContentType.TEXT_PLAIN.withCharset(StandardCharsets.UTF_8));
            builder.addBinaryBody("file", Mix.getFinalResourcePack(), ContentType.APPLICATION_OCTET_STREAM, Mix.getFinalResourcePack().getName());
            uploadFile.setEntity(builder.build());
            try (CloseableHttpResponse response = httpClient.execute(uploadFile);){
                String responseString = EntityUtils.toString(response.getEntity());
                int statusCode = response.getCode();
                if (statusCode >= 200 && statusCode < 300) {
                    Logger.info("Uploaded resource pack for automatic hosting! url: https://magmaguy.com/rsp/" + rspUUID);
                    done = true;
                    if (firstUpload) {
                        for (Player player : Bukkit.getOnlinePlayers()) {
                            AutoHost.sendResourcePack(player);
                        }
                    }
                    firstUpload = false;
                } else {
                    AutoHost.handleErrorResponse(responseString, statusCode, "upload");
                }
            }
            catch (Exception e) {
                Logger.warn("Failed to communicate with remote server during upload!");
                e.printStackTrace();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Exception decompiling
     */
    private static boolean sendSHA1() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 5 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static void sendStillAlive() throws IOException {
        try (CloseableHttpClient httpClient = HttpClients.createDefault();){
            HttpPost httpPost = new HttpPost("https://magmaguy.com/rsp/still_alive");
            MultipartEntityBuilder builder = MultipartEntityBuilder.create();
            builder.addTextBody("uuid", rspUUID);
            httpPost.setEntity(builder.build());
            try (CloseableHttpResponse response = httpClient.execute(httpPost);){
                String responseString = EntityUtils.toString(response.getEntity());
                int statusCode = response.getCode();
                if (statusCode >= 200 && statusCode < 300) {
                } else {
                    AutoHost.handleErrorResponse(responseString, statusCode, "still alive");
                    rspUUID = null;
                }
            }
            catch (Exception e) {
                Logger.warn("Failed to communicate with remote server during still alive ping!");
                e.printStackTrace();
            }
        }
    }

    public static void dataComplianceRequest() throws IOException {
        block22: {
            try (CloseableHttpClient httpClient = HttpClients.createDefault();){
                HttpPost httpPost = new HttpPost("https://magmaguy.com/rsp/data_compliance");
                MultipartEntityBuilder builder = MultipartEntityBuilder.create();
                builder.addTextBody("uuid", rspUUID);
                httpPost.setEntity(builder.build());
                try (CloseableHttpResponse response = httpClient.execute(httpPost);){
                    HttpEntity responseEntity = response.getEntity();
                    if (responseEntity == null) break block22;
                    File zipFile = new File(ResourcePackManager.plugin.getDataFolder().getAbsolutePath() + File.separatorChar + "data_compliance" + File.separatorChar + "data.zip");
                    if (!zipFile.getParentFile().exists()) {
                        zipFile.mkdirs();
                    }
                    if (zipFile.exists()) {
                        zipFile.delete();
                    }
                    zipFile.createNewFile();
                    try (FileOutputStream outStream = new FileOutputStream(zipFile);){
                        responseEntity.writeTo(outStream);
                    }
                    InputStream inputStream = ResourcePackManager.plugin.getResource("ReadMe.md");
                    File readMe = new File(ResourcePackManager.plugin.getDataFolder().getAbsolutePath() + File.separatorChar + "data_compliance" + File.separatorChar + "ReadMe.md");
                    if (!readMe.exists()) {
                        readMe.createNewFile();
                    }
                    Files.copy(inputStream, readMe.toPath(), StandardCopyOption.REPLACE_EXISTING);
                }
                catch (Exception e) {
                    Logger.warn("Failed to communicate with remote server!");
                    e.printStackTrace();
                }
            }
        }
    }

    public static void shutdown() {
        if (keepAlive != null) {
            keepAlive.cancel();
        }
        done = false;
        rspUUID = null;
    }

    private static void handleErrorResponse(String responseString, int statusCode, String operation) {
        try {
            Gson gson = new Gson();
            JsonObject errorResponse = gson.fromJson(responseString, JsonObject.class);
            if (errorResponse.has("error")) {
                JsonObject error = errorResponse.getAsJsonObject("error");
                String errorCode = error.get("code").getAsString();
                String errorMessage = error.get("message").getAsString();
                String errorType = error.get("type").getAsString();
                Logger.warn("=== Resource Pack " + operation.toUpperCase() + " ERROR ===");
                Logger.warn("Error Code: " + errorCode);
                Logger.warn("Error Type: " + errorType);
                Logger.warn("Message: " + errorMessage);
                Logger.warn("HTTP Status: " + statusCode);
                Logger.warn("=====================================");
                switch (errorCode) {
                    case "MISSING_REQUIRED_FILES": {
                        Logger.warn("Your resource pack structure is incorrect!");
                        Logger.warn("Make sure pack.png and pack.mcmeta are in the root of your zip file.");
                        break;
                    }
                    case "FILE_TOO_LARGE": {
                        Logger.warn("Your resource pack is too large! Please reduce the file size.");
                        break;
                    }
                    case "INVALID_FILE_FORMAT": {
                        Logger.warn("Your resource pack file is corrupted or not a valid zip file.");
                        break;
                    }
                    case "SESSION_NOT_FOUND": {
                        Logger.warn("Server session expired. Will attempt to reinitialize...");
                        rspUUID = null;
                        break;
                    }
                    case "SERVER_UNAVAILABLE": {
                        Logger.warn("Remote server is temporarily unavailable. Will retry later.");
                    }
                }
            } else {
                Logger.warn("Server error during " + operation + " (HTTP " + statusCode + "): " + responseString);
            }
        }
        catch (Exception e) {
            Logger.warn("Server error during " + operation + " (HTTP " + statusCode + "): " + responseString);
        }
    }

    @Generated
    public static void setDone(boolean done) {
        AutoHost.done = done;
    }

    @Generated
    public static String getRspUUID() {
        return rspUUID;
    }

    @Generated
    public static void setFirstUpload(boolean firstUpload) {
        AutoHost.firstUpload = firstUpload;
    }
}

