/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.resourcepackmanager.config;

import com.magmaguy.magmacore.config.ConfigurationFile;
import com.magmaguy.magmacore.util.Logger;
import java.util.UUID;

public class DataConfig
extends ConfigurationFile {
    private static DataConfig instance = null;

    public DataConfig() {
        super("data.yml");
        instance = this;
    }

    public static String getRspUUID() {
        String uuid = instance.getFileConfiguration().getString("uuid");
        if (uuid != null && !uuid.isEmpty() && !DataConfig.isValidUUID(uuid)) {
            Logger.warn("Invalid UUID found in config file: " + uuid + ". Deleting invalid UUID from file.");
            instance.clearInvalidUUID();
            return null;
        }
        return uuid == null || uuid.isEmpty() ? "" : uuid;
    }

    public static void setRspUUID(String rspUUID) {
        if (rspUUID != null && !rspUUID.isEmpty() && !DataConfig.isValidUUID(rspUUID)) {
            throw new IllegalArgumentException("Invalid UUID format: " + rspUUID + ". UUID must be in format: xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx");
        }
        instance.getFileConfiguration().set("uuid", (Object)rspUUID);
        try {
            instance.getFileConfiguration().save(DataConfig.instance.file);
            if (rspUUID != null && !rspUUID.isEmpty()) {
                Logger.info("Successfully saved UUID: " + rspUUID);
            } else {
                Logger.info("Successfully cleared UUID from config.");
            }
        }
        catch (Exception e) {
            Logger.warn("Failed to save uuid!");
            e.printStackTrace();
        }
    }

    private void clearInvalidUUID() {
        this.getFileConfiguration().set("uuid", null);
        try {
            this.getFileConfiguration().save(this.file);
            Logger.info("Invalid UUID cleared from config file.");
        }
        catch (Exception e) {
            Logger.warn("Failed to clear invalid UUID from config!");
            e.printStackTrace();
        }
    }

    private static boolean isValidUUID(String uuidString) {
        if (uuidString == null || uuidString.trim().isEmpty()) {
            return false;
        }
        try {
            UUID.fromString(uuidString.trim());
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    @Override
    public void initializeValues() {
        String existingUUID = this.getFileConfiguration().getString("uuid");
        if (existingUUID != null && !existingUUID.isEmpty() && !DataConfig.isValidUUID(existingUUID)) {
            Logger.warn("Invalid UUID found in config file during initialization: " + existingUUID);
            Logger.warn("Deleting invalid UUID from file. A new one will be generated on next server connection.");
            this.clearInvalidUUID();
        }
    }
}

