/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.resourcepackmanager.itemsadder;

import com.magmaguy.magmacore.util.Logger;
import com.magmaguy.resourcepackmanager.ResourcePackManager;
import java.io.File;
import org.bukkit.Bukkit;
import org.bukkit.configuration.file.YamlConfiguration;

public class ItemsAdderDetector {
    private ItemsAdderDetector() {
    }

    public static boolean isItemsAdderInstalled() {
        return Bukkit.getPluginManager().isPluginEnabled("ItemsAdder");
    }

    public static boolean isItemsAdderHosting() {
        if (!ItemsAdderDetector.isItemsAdderInstalled()) {
            return false;
        }
        File configFile = ItemsAdderDetector.getItemsAdderConfigFile();
        if (configFile == null || !configFile.exists()) {
            Logger.warn("Could not find ItemsAdder config.yml");
            return false;
        }
        try {
            YamlConfiguration config = YamlConfiguration.loadConfiguration((File)configFile);
            boolean selfHostEnabled = config.getBoolean("resource-pack.hosting.self-host.enabled", false);
            if (selfHostEnabled) {
                Logger.info("ItemsAdder is configured with self-host enabled");
                return true;
            }
            String externalHostUrl = config.getString("resource-pack.hosting.external-host.url", "");
            if (externalHostUrl != null && !externalHostUrl.isEmpty() && !externalHostUrl.equals("http://example.com/resourcepack.zip")) {
                Logger.info("ItemsAdder is configured with external-host URL: " + externalHostUrl);
                return true;
            }
            boolean lobfileEnabled = config.getBoolean("resource-pack.hosting.lobfile.enabled", false);
            if (lobfileEnabled) {
                Logger.info("ItemsAdder is configured with lobfile hosting enabled");
                return true;
            }
            boolean noHostEnabled = config.getBoolean("resource-pack.hosting.no-host.enabled", false);
            if (noHostEnabled) {
                Logger.info("ItemsAdder has no-host enabled - not hosting");
                return false;
            }
            return false;
        }
        catch (Exception e) {
            Logger.warn("Failed to read ItemsAdder config: " + e.getMessage());
            return false;
        }
    }

    public static boolean hasProtectionEnabled() {
        if (!ItemsAdderDetector.isItemsAdderInstalled()) {
            return false;
        }
        File configFile = ItemsAdderDetector.getItemsAdderConfigFile();
        if (configFile == null || !configFile.exists()) {
            return false;
        }
        try {
            YamlConfiguration config = YamlConfiguration.loadConfiguration((File)configFile);
            boolean protection1 = config.getBoolean("resource-pack.zip.protect-file-from-unzip.protection_1", false);
            boolean protection2 = config.getBoolean("resource-pack.zip.protect-file-from-unzip.protection_2", false);
            boolean protection3 = config.getBoolean("resource-pack.zip.protect-file-from-unzip.protection_3", false);
            return protection1 || protection2 || protection3;
        }
        catch (Exception e) {
            Logger.warn("Failed to check ItemsAdder protection settings: " + e.getMessage());
            return false;
        }
    }

    public static File getItemsAdderConfigFile() {
        File pluginsFolder = ResourcePackManager.plugin.getDataFolder().getParentFile();
        return new File(pluginsFolder, "ItemsAdder" + File.separatorChar + "config.yml");
    }

    public static boolean needsConfiguration() {
        if (!ItemsAdderDetector.isItemsAdderInstalled()) {
            return false;
        }
        if (ItemsAdderDetector.isItemsAdderHosting()) {
            return false;
        }
        File configFile = ItemsAdderDetector.getItemsAdderConfigFile();
        if (configFile == null || !configFile.exists()) {
            return false;
        }
        try {
            YamlConfiguration config = YamlConfiguration.loadConfiguration((File)configFile);
            boolean noHostEnabled = config.getBoolean("resource-pack.hosting.no-host.enabled", false);
            if (noHostEnabled && ItemsAdderDetector.hasProtectionEnabled()) {
                return true;
            }
            return !noHostEnabled;
        }
        catch (Exception e) {
            return false;
        }
    }
}

