/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.resourcepackmanager.itemsadder;

import com.magmaguy.magmacore.util.ChatColorConverter;
import com.magmaguy.resourcepackmanager.ResourcePackManager;
import com.magmaguy.resourcepackmanager.itemsadder.ItemsAdderDetector;
import com.magmaguy.resourcepackmanager.itemsadder.ItemsAdderDismissedConfig;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.HoverEvent;
import net.md_5.bungee.api.chat.TextComponent;
import net.md_5.bungee.api.chat.hover.content.Content;
import net.md_5.bungee.api.chat.hover.content.Text;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class ItemsAdderWarningListener
implements Listener {
    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        final Player player = event.getPlayer();
        if (!player.isOp()) {
            return;
        }
        if (ItemsAdderDismissedConfig.hasDismissed(player.getUniqueId())) {
            return;
        }
        if (!ItemsAdderDetector.needsConfiguration()) {
            return;
        }
        new BukkitRunnable(){

            public void run() {
                if (!player.isOnline()) {
                    return;
                }
                ItemsAdderWarningListener.this.sendWarning(player);
            }
        }.runTaskLater((Plugin)ResourcePackManager.plugin, 60L);
    }

    private void sendWarning(Player player) {
        player.sendTitle(ChatColorConverter.convert("&c&lItemsAdder Detected"), ChatColorConverter.convert("&eResource pack not configured - check chat!"), 10, 70, 20);
        player.sendMessage("");
        player.sendMessage(ChatColorConverter.convert("&8&m----------------------------------------"));
        player.sendMessage(ChatColorConverter.convert("&c&lItemsAdder Configuration Warning"));
        player.sendMessage(ChatColorConverter.convert("&8&m----------------------------------------"));
        player.sendMessage("");
        player.sendMessage(ChatColorConverter.convert("&eItemsAdder has been detected but is not currently"));
        player.sendMessage(ChatColorConverter.convert("&econfigured to let ResourcePackManager host the resource pack."));
        player.sendMessage("");
        player.sendMessage(ChatColorConverter.convert("&7For ResourcePackManager to merge and host the resource pack,"));
        player.sendMessage(ChatColorConverter.convert("&7ItemsAdder needs to have hosting disabled and protections off."));
        player.sendMessage("");
        TextComponent configureButton = new TextComponent(ChatColorConverter.convert("&a&l[Configure Automatically]"));
        configureButton.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/rspm itemsadder configure"));
        configureButton.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new Content[]{new Text(ChatColorConverter.convert("&aClick to automatically configure ItemsAdder\n&7This will:\n&7- Enable no-host mode\n&7- Disable file protections\n&7- Reload both plugins"))}));
        TextComponent dismissButton = new TextComponent(ChatColorConverter.convert("&c&l[Dismiss Permanently]"));
        dismissButton.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/rspm itemsadder dismiss"));
        dismissButton.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new Content[]{new Text(ChatColorConverter.convert("&cClick to dismiss this warning permanently\n&7You won't see this warning again"))}));
        TextComponent space = new TextComponent("  ");
        player.spigot().sendMessage(new BaseComponent[]{configureButton, space, dismissButton});
        player.sendMessage("");
        player.sendMessage(ChatColorConverter.convert("&8&m----------------------------------------"));
        player.sendMessage("");
    }
}

