/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.resourcepackmanager.org.apache.hc.client5.http.auth;

import com.magmaguy.resourcepackmanager.org.apache.hc.client5.http.auth.BasicUserPrincipal;
import com.magmaguy.resourcepackmanager.org.apache.hc.client5.http.auth.Credentials;
import com.magmaguy.resourcepackmanager.org.apache.hc.core5.annotation.Contract;
import com.magmaguy.resourcepackmanager.org.apache.hc.core5.annotation.ThreadingBehavior;
import com.magmaguy.resourcepackmanager.org.apache.hc.core5.util.Args;
import java.io.Serializable;
import java.security.Principal;
import java.util.Objects;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class UsernamePasswordCredentials
implements Credentials,
Serializable {
    private static final long serialVersionUID = 243343858802739403L;
    private final Principal principal;
    private final char[] password;

    public UsernamePasswordCredentials(Principal principal, char[] password) {
        this.principal = Args.notNull(principal, "User principal");
        this.password = password;
    }

    public UsernamePasswordCredentials(String username, char[] password) {
        this(new BasicUserPrincipal(username), password);
    }

    @Override
    public Principal getUserPrincipal() {
        return this.principal;
    }

    public String getUserName() {
        return this.principal.getName();
    }

    public char[] getUserPassword() {
        return this.password;
    }

    @Override
    @Deprecated
    public char[] getPassword() {
        return this.password;
    }

    public int hashCode() {
        return this.principal.hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof UsernamePasswordCredentials) {
            UsernamePasswordCredentials that = (UsernamePasswordCredentials)o;
            return Objects.equals(this.principal, that.principal);
        }
        return false;
    }

    public String toString() {
        return this.principal.toString();
    }
}

