/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.resourcepackmanager.org.apache.hc.core5.reactor;

import com.magmaguy.resourcepackmanager.org.apache.hc.core5.concurrent.FutureCallback;
import com.magmaguy.resourcepackmanager.org.apache.hc.core5.net.NamedEndpoint;
import com.magmaguy.resourcepackmanager.org.apache.hc.core5.reactor.ConnectionInitiator;
import com.magmaguy.resourcepackmanager.org.apache.hc.core5.reactor.IOReactorService;
import com.magmaguy.resourcepackmanager.org.apache.hc.core5.reactor.IOReactorShutdownException;
import com.magmaguy.resourcepackmanager.org.apache.hc.core5.reactor.IOReactorStatus;
import com.magmaguy.resourcepackmanager.org.apache.hc.core5.reactor.IOSession;
import com.magmaguy.resourcepackmanager.org.apache.hc.core5.reactor.IOWorkers;
import com.magmaguy.resourcepackmanager.org.apache.hc.core5.util.Args;
import com.magmaguy.resourcepackmanager.org.apache.hc.core5.util.Timeout;
import java.net.SocketAddress;
import java.util.concurrent.Future;

abstract class AbstractIOReactorBase
implements ConnectionInitiator,
IOReactorService {
    AbstractIOReactorBase() {
    }

    @Override
    public final Future<IOSession> connect(NamedEndpoint remoteEndpoint, SocketAddress remoteAddress, SocketAddress localAddress, Timeout timeout, Object attachment, FutureCallback<IOSession> callback) throws IOReactorShutdownException {
        Args.notNull(remoteEndpoint, "Remote endpoint");
        if (this.getStatus().compareTo(IOReactorStatus.ACTIVE) > 0) {
            throw new IOReactorShutdownException("I/O reactor has been shut down");
        }
        try {
            return this.getWorkerSelector().next().connect(remoteEndpoint, remoteAddress, localAddress, timeout, attachment, callback);
        }
        catch (IOReactorShutdownException ex) {
            this.initiateShutdown();
            throw ex;
        }
    }

    abstract IOWorkers.Selector getWorkerSelector();
}

