/*
 * Decompiled with CFR 0.152.
 */
package bl4ckscor3.mod.woolbuttons;

import bl4ckscor3.mod.woolbuttons.Configuration;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;

public class WoolButtonBlock
extends ButtonBlock {
    public WoolButtonBlock(BlockBehaviour.Properties properties, BlockSetType blockSetType, int ticksToStayPressed) {
        super(blockSetType, ticksToStayPressed, properties);
    }

    public InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hit) {
        if (((Boolean)state.getValue((Property)POWERED)).booleanValue()) {
            return InteractionResult.CONSUME;
        }
        this.press(state, level, pos, player);
        this.playSound(player, (LevelAccessor)level, pos, true);
        if (((Boolean)Configuration.CONFIG.triggerSculkSensors.get()).booleanValue()) {
            level.gameEvent((Entity)player, (Holder)GameEvent.BLOCK_ACTIVATE, pos);
        }
        return InteractionResult.SUCCESS;
    }

    protected void checkPressed(BlockState state, Level level, BlockPos pos) {
        boolean isButtonPowered;
        AbstractArrow arrow = this.type.canButtonBeActivatedByArrows() ? (AbstractArrow)level.getEntitiesOfClass(AbstractArrow.class, state.getShape((BlockGetter)level, pos).bounds().move(pos)).stream().findFirst().orElse(null) : null;
        boolean isArrowNotNull = arrow != null;
        if (isArrowNotNull != (isButtonPowered = ((Boolean)state.getValue((Property)POWERED)).booleanValue())) {
            level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)POWERED, (Comparable)Boolean.valueOf(isArrowNotNull)));
            this.updateNeighbours(state, level, pos);
            this.playSound(null, (LevelAccessor)level, pos, isArrowNotNull);
            if (((Boolean)Configuration.CONFIG.triggerSculkSensors.get()).booleanValue()) {
                level.gameEvent((Entity)arrow, (Holder)(isArrowNotNull ? GameEvent.BLOCK_ACTIVATE : GameEvent.BLOCK_DEACTIVATE), pos);
            }
        }
        if (isArrowNotNull) {
            level.scheduleTick(new BlockPos((Vec3i)pos), (Block)this, this.ticksToStayPressed);
        }
    }

    protected SoundEvent getSound(boolean isPressed) {
        if (((Boolean)Configuration.CONFIG.makeSound.get()).booleanValue()) {
            return super.getSound(isPressed);
        }
        return SoundEvents.EMPTY;
    }
}

