/*
 * Decompiled with CFR 0.152.
 */
package bl4ckscor3.mod.woolbuttons;

import bl4ckscor3.mod.woolbuttons.Configuration;
import bl4ckscor3.mod.woolbuttons.WoolButtonBlock;
import java.util.EnumMap;
import java.util.Map;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;
import net.neoforged.neoforge.registries.RegisterEvent;

@Mod(value="sbmwoolbuttons")
@EventBusSubscriber(modid="sbmwoolbuttons")
public class WoolButtons {
    public static final String MODID = "sbmwoolbuttons";
    public static final BlockSetType WOOL_BUTTON_BLOCK_SET_TYPE = BlockSetType.register((BlockSetType)new BlockSetType("sbmwoolbuttons:wool", true, true, true, BlockSetType.PressurePlateSensitivity.EVERYTHING, SoundType.WOOL, SoundEvents.EMPTY, SoundEvents.EMPTY, SoundEvents.EMPTY, SoundEvents.EMPTY, SoundEvents.EMPTY, SoundEvents.EMPTY, SoundEvents.WOODEN_BUTTON_CLICK_OFF, SoundEvents.WOODEN_BUTTON_CLICK_ON));
    public static final Map<Color, Block> BLOCKS = new EnumMap<Color, Block>(Color.class);
    public static final Map<Color, BlockItem> ITEMS = new EnumMap<Color, BlockItem>(Color.class);

    public WoolButtons(ModContainer modContainer) {
        modContainer.registerConfig(ModConfig.Type.SERVER, (IConfigSpec)Configuration.CONFIG_SPEC);
    }

    @SubscribeEvent
    public static void onRegister(RegisterEvent event) {
        event.register(Registries.BLOCK, helper -> {
            for (Color color : Color.values()) {
                ResourceLocation name = WoolButtons.getName(color);
                WoolButtonBlock block = new WoolButtonBlock(BlockBehaviour.Properties.of().noCollision().strength(0.5f).setId(ResourceKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)name)), WOOL_BUTTON_BLOCK_SET_TYPE, 30);
                helper.register(name, (Object)block);
                BLOCKS.put(color, (Block)block);
            }
        });
        event.register(Registries.ITEM, helper -> {
            for (Color color : Color.values()) {
                ResourceLocation name = WoolButtons.getName(color);
                BuiltInRegistries.BLOCK.get(name).ifPresent(ref -> {
                    Block block = (Block)ref.value();
                    if (block != null) {
                        BlockItem blockItem = new BlockItem(block, new Item.Properties().setId(ResourceKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)name)).useBlockDescriptionPrefix());
                        helper.register(name, (Object)blockItem);
                        ITEMS.put(color, blockItem);
                    }
                });
            }
        });
    }

    @SubscribeEvent
    public static void onCreativeModeTabBuildContents(BuildCreativeModeTabContentsEvent event) {
        if (event.getTabKey() == CreativeModeTabs.REDSTONE_BLOCKS) {
            event.insertAfter(new ItemStack((ItemLike)Items.STONE_BUTTON), new ItemStack((ItemLike)ITEMS.get((Object)Color.WHITE)), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
        } else if (event.getTabKey() == CreativeModeTabs.COLORED_BLOCKS) {
            event.acceptAll(ITEMS.values().stream().map(ItemStack::new).toList());
        }
    }

    public static ResourceLocation getName(Color color) {
        return ResourceLocation.fromNamespaceAndPath((String)MODID, (String)("wool_button_" + color.name().toLowerCase()));
    }

    public static enum Color {
        WHITE,
        LIGHT_GRAY,
        GRAY,
        BLACK,
        BROWN,
        RED,
        ORANGE,
        YELLOW,
        LIME,
        GREEN,
        CYAN,
        LIGHT_BLUE,
        BLUE,
        PURPLE,
        MAGENTA,
        PINK;

    }
}

