/*
 * Decompiled with CFR 0.152.
 */
package net.fryc.frycmobvariants.mobs.cave;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import net.fryc.frycmobvariants.MobVariants;
import net.fryc.frycmobvariants.util.MobConvertingHelper;
import net.fryc.frycmobvariants.util.StatusEffectHelper;
import net.fryc.frycmobvariants.util.StringHelper;
import net.minecraft.class_1266;
import net.minecraft.class_1282;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1315;
import net.minecraft.class_1588;
import net.minecraft.class_1613;
import net.minecraft.class_1665;
import net.minecraft.class_1667;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1811;
import net.minecraft.class_1844;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1893;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_3414;
import net.minecraft.class_3730;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5425;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import net.minecraft.class_9334;
import org.jetbrains.annotations.Nullable;
import oshi.util.tuples.Pair;

public class UndeadWarriorEntity
extends class_1613 {
    public Random rand = new Random();
    public int tippedArrowsAmount;
    public Pair<class_6880<class_1291>, Pair<Integer, Integer>> tippedArrowEffect;
    public static Map<class_1792, Pair<Float, Float>> undeadWarriorWeapons = new HashMap<class_1792, Pair>(Map.of(class_1802.field_8102, new Pair((Object)Float.valueOf(0.0f), (Object)Float.valueOf(0.5f)), class_1802.field_8528, new Pair((Object)Float.valueOf(0.5f), (Object)Float.valueOf(1.0f))));

    public UndeadWarriorEntity(class_1299<? extends class_1613> entityType, class_1937 world) {
        super(entityType, world);
        if (!world.method_8608()) {
            int minTippedArrows = MobVariants.config.undeadWarriorAttributes.undeadWarriorsMinTippedArrowsCount;
            this.tippedArrowsAmount = this.rand.nextInt(minTippedArrows, Math.max(MobVariants.config.undeadWarriorAttributes.undeadWarriorsMaxTippedArrowsCount + 1, minTippedArrows + 1));
            this.tippedArrowEffect = StatusEffectHelper.pickRandomStatusEffect(this.rand);
        } else {
            this.tippedArrowsAmount = 1;
            this.tippedArrowEffect = new Pair((Object)class_1294.field_5911, (Object)new Pair((Object)400, (Object)1));
        }
        ++this.field_6194;
    }

    public static class_5132.class_5133 createUndeadWarriorAttributes() {
        return class_1588.method_26918().method_26868(class_5134.field_23717, 40.0).method_26868(class_5134.field_23719, 0.2505).method_26868(class_5134.field_23716, 22.0).method_26868(class_5134.field_23718, (double)0.2f);
    }

    protected void method_5964(class_5819 random, class_1266 localDifficulty) {
        this.method_5673(class_1304.field_6173, UndeadWarriorEntity.getUndeadWarriorWeapon());
        if (!(this.method_6047().method_7909() instanceof class_1811)) {
            this.tippedArrowsAmount = -1;
        }
    }

    @Nullable
    public class_1315 method_5943(class_5425 world, class_1266 difficulty, class_3730 spawnReason, @Nullable class_1315 entityData) {
        class_1315 entityData2 = super.method_5943(world, difficulty, spawnReason, entityData);
        this.method_5996(class_5134.field_23721).method_6192(3.0);
        this.method_6997();
        return entityData2;
    }

    protected class_1665 method_6996(class_1799 arrow, float damageModifier) {
        class_1665 persistentProjectileEntity = super.method_6996(arrow, damageModifier);
        if (this.tippedArrowsAmount > 0) {
            if (persistentProjectileEntity instanceof class_1667) {
                int duration = (Integer)((Pair)this.tippedArrowEffect.getB()).getA() > 0 ? (Integer)((Pair)this.tippedArrowEffect.getB()).getA() : 1;
                int amplifier = (Integer)((Pair)this.tippedArrowEffect.getB()).getB() > 0 ? (Integer)((Pair)this.tippedArrowEffect.getB()).getB() - 1 : 0;
                ((class_1667)persistentProjectileEntity).method_7463(new class_1293((class_6880)this.tippedArrowEffect.getA(), duration, amplifier));
            }
            --this.tippedArrowsAmount;
        }
        return persistentProjectileEntity;
    }

    public static class_1799 getUndeadWarriorWeapon() {
        return MobConvertingHelper.getRandomItemStack(undeadWarriorWeapons);
    }

    public void method_5652(class_2487 nbt) {
        super.method_5652(nbt);
        nbt.method_10569("TippedArrowsAmount", this.tippedArrowsAmount);
        nbt.method_10582("TippedArrowEffect", ((class_6880)this.tippedArrowEffect.getA()).method_55840());
        nbt.method_10569("TippedArrowDuration", ((Integer)((Pair)this.tippedArrowEffect.getB()).getA()).intValue());
        nbt.method_10569("TippedArrowAmplifier", ((Integer)((Pair)this.tippedArrowEffect.getB()).getB()).intValue());
    }

    public void method_5749(class_2487 nbt) {
        super.method_5749(nbt);
        if (nbt.method_10545("TippedArrowsAmount")) {
            this.tippedArrowsAmount = nbt.method_10550("TippedArrowsAmount");
        }
        if (nbt.method_10545("TippedArrowEffect") && nbt.method_10545("TippedArrowDuration") && nbt.method_10545("TippedArrowAmplifier")) {
            this.tippedArrowEffect = new Pair(StringHelper.getStatusEffectFromString(nbt.method_10558("TippedArrowEffect")), (Object)new Pair((Object)nbt.method_10550("TippedArrowDuration"), (Object)nbt.method_10550("TippedArrowAmplifier")));
        }
    }

    public void method_5966() {
        class_3414 soundEvent = this.method_5994();
        if (soundEvent != null) {
            this.method_5783(soundEvent, this.method_6107(), this.method_6017() - 0.25f);
        }
    }

    protected void method_6013(class_1282 source) {
        this.resetSoundDelay();
        class_3414 soundEvent = this.method_6011(source);
        if (soundEvent != null) {
            this.method_5783(soundEvent, this.method_6107(), this.method_6017() - 0.15f);
        }
    }

    private void resetSoundDelay() {
        this.field_6191 = -this.method_5970();
    }

    protected void method_16077(class_1282 damageSource, boolean causedByPlayer) {
        if (!this.method_37908().method_8608() && causedByPlayer && this.tippedArrowsAmount > -1) {
            int arrowCount;
            int lootingLevel;
            class_1297 class_12972 = damageSource.method_5529();
            if (class_12972 instanceof class_1309) {
                class_1309 entity = (class_1309)class_12972;
                v0 = class_1890.method_8203((class_1887)class_1893.field_9110, (class_1309)entity);
            } else {
                v0 = lootingLevel = 0;
            }
            if (this.rand.nextInt(0, 100) < this.tippedArrowsAmount * MobVariants.config.undeadWarriorAttributes.undeadWarriorsTippedArrowDropChancePerTippedArrowHeld + 1 + lootingLevel * 2) {
                class_1799 stack = new class_1799((class_1935)class_1802.field_8087);
                int duration = (Integer)((Pair)this.tippedArrowEffect.getB()).getA() * 9;
                int amp = (Integer)((Pair)this.tippedArrowEffect.getB()).getB() > 0 ? (Integer)((Pair)this.tippedArrowEffect.getB()).getB() - 1 : 0;
                stack.method_57379(class_9334.field_49651, (Object)new class_1844(Optional.empty(), Optional.of(((class_1291)((class_6880)this.tippedArrowEffect.getA()).comp_349()).method_5556()), List.of(new class_1293((class_6880)this.tippedArrowEffect.getA(), duration, amp))));
                this.method_5775(stack);
            }
            if ((arrowCount = this.rand.nextInt(0, 3 + lootingLevel)) > 0) {
                this.method_5775(new class_1799((class_1935)class_1802.field_8107, arrowCount));
            }
        }
        super.method_16077(damageSource, causedByPlayer);
    }
}

