/*
 * Decompiled with CFR 0.152.
 */
package net.fryc.frycmobvariants.util;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import net.fryc.frycmobvariants.MobVariants;
import net.minecraft.class_1291;
import net.minecraft.class_1294;
import net.minecraft.class_1792;
import net.minecraft.class_2960;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;
import oshi.util.tuples.Pair;

public class StringHelper {
    public static HashMap<String, Pair<Integer, Integer>> transformStringToIntMap(String stringsAndNumbers) {
        HashMap<String, Pair<Integer, Integer>> map = new HashMap<String, Pair<Integer, Integer>>();
        Iterator iterator = Arrays.stream(stringsAndNumbers.split(";", 0)).iterator();
        int i = 0;
        String key = "";
        int fValue = 0;
        int sValue = 0;
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            switch (i) {
                case 0: {
                    key = string;
                    break;
                }
                case 1: {
                    try {
                        fValue = Integer.parseInt(string);
                    }
                    catch (Exception e) {
                        MobVariants.LOGGER.error("An error occurred while reading MobVariants config. Given String could not be parsed to int", (Throwable)e);
                    }
                    break;
                }
                case 2: {
                    try {
                        sValue = Integer.parseInt(string);
                    }
                    catch (Exception e) {
                        MobVariants.LOGGER.error("An error occurred while reading MobVariants config. Given String could not be parsed to int", (Throwable)e);
                    }
                    break;
                }
                default: {
                    map.put(key, (Pair<Integer, Integer>)new Pair((Object)fValue, (Object)sValue));
                    key = string;
                    i = 0;
                }
            }
            ++i;
        }
        if (i == 3) {
            map.put(key, (Pair<Integer, Integer>)new Pair((Object)fValue, (Object)sValue));
        }
        return map;
    }

    public static HashMap<class_1792, Pair<Float, Float>> transformStringToFloatMap(String stringsAndNumbers) {
        HashMap<class_1792, Pair<Float, Float>> map = new HashMap<class_1792, Pair<Float, Float>>();
        Iterator iterator = Arrays.stream(stringsAndNumbers.split(";", 0)).iterator();
        int i = 0;
        String key = "";
        float fValue = 0.0f;
        float sValue = 0.0f;
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            switch (i) {
                case 0: {
                    key = string;
                    break;
                }
                case 1: {
                    try {
                        fValue = Float.parseFloat(string) + sValue;
                    }
                    catch (Exception e) {
                        MobVariants.LOGGER.error("An error occurred while reading MobVariants config. Given String could not be parsed to float", (Throwable)e);
                    }
                    break;
                }
                default: {
                    StringHelper.putIfKeyNotNull(map, StringHelper.transformStringToItem(key), sValue, fValue);
                    sValue = fValue;
                    key = string;
                    i = 0;
                }
            }
            ++i;
        }
        if (i == 2) {
            StringHelper.putIfKeyNotNull(map, StringHelper.transformStringToItem(key), sValue, fValue);
        }
        return map;
    }

    private static void putIfKeyNotNull(Map<class_1792, Pair<Float, Float>> map, @Nullable class_1792 key, float sValue, float fValue) {
        if (key != null) {
            map.put(key, (Pair<Float, Float>)new Pair((Object)Float.valueOf(sValue), (Object)Float.valueOf(fValue)));
        }
    }

    @Nullable
    public static class_1792 transformStringToItem(String item) {
        Optional optional = class_7923.field_41178.method_17966(class_2960.method_60654((String)item));
        if (optional.isEmpty()) {
            MobVariants.LOGGER.error("An error occurred while reading MobVariants config. Unknown item: " + item);
            return null;
        }
        return (class_1792)optional.get();
    }

    public static class_6880<class_1291> getStatusEffectFromString(String statusEffect) {
        return (class_6880)class_7923.field_41174.method_55841(class_2960.method_60654((String)statusEffect)).orElseGet(() -> {
            MobVariants.LOGGER.error("Unable to find the following status effect: '" + statusEffect + "'");
            return (class_6880.class_6883)class_1294.field_5911;
        });
    }
}

