/*
 * Decompiled with CFR 0.152.
 */
package com.notcharrow.tnttweaks.config;

import com.notcharrow.tnttweaks.config.ConfigManager;
import com.terraformersmc.modmenu.api.ConfigScreenFactory;
import com.terraformersmc.modmenu.api.ModMenuApi;
import java.util.function.Consumer;
import me.shedaniel.clothconfig2.api.AbstractConfigListEntry;
import me.shedaniel.clothconfig2.api.ConfigBuilder;
import me.shedaniel.clothconfig2.api.ConfigCategory;
import net.minecraft.class_2561;
import net.minecraft.class_437;

public class TNTTweaksModMenu
implements ModMenuApi {
    public ConfigScreenFactory<?> getModConfigScreenFactory() {
        return this::createConfigScreen;
    }

    private class_437 createConfigScreen(class_437 parent) {
        ConfigBuilder builder = ConfigBuilder.create().setParentScreen(parent).setTitle(class_2561.method_30163((String)"TNT Tweaks Config"));
        ConfigCategory general = builder.getOrCreateCategory(class_2561.method_30163((String)"General Settings"));
        this.addBoolean(general, "Mod Enabled", "Overall toggle for all mod functionality", ConfigManager.config.modEnabled, value -> {
            ConfigManager.config.modEnabled = value;
        });
        this.addBoolean(general, "Auto Ignite", "Should TNT Auto Ignite when placed", ConfigManager.config.autoIgnite, value -> {
            ConfigManager.config.autoIgnite = value;
        });
        this.addIntField(general, "Fuse Time (ticks)", "Fuse time for lit TNT; only works with auto ignite", ConfigManager.config.fuseTime, value -> {
            ConfigManager.config.fuseTime = value;
        }, 0, 1200);
        this.addBoolean(general, "Break Blocks", "Should TNT break blocks", ConfigManager.config.breakBlocks, value -> {
            ConfigManager.config.breakBlocks = value;
        });
        this.addBoolean(general, "Ignore Blast Resistance", "Should TNT ignore block blast resistance", ConfigManager.config.ignoreBlastResistance, value -> {
            ConfigManager.config.ignoreBlastResistance = value;
        });
        this.addBoolean(general, "Modify Knockback", "Should TNT deal modified knockback", ConfigManager.config.modifyKnockback, value -> {
            ConfigManager.config.modifyKnockback = value;
        });
        this.addFloatField(general, "Knockback Modifier Blocks", "Should TNT break blocks", ConfigManager.config.knockbackModifier, value -> {
            ConfigManager.config.knockbackModifier = value.floatValue();
        }, 0.0f, 100.0f);
        this.addBoolean(general, "Placer Immunity", "Should the placer be given immunity from TNT damage", ConfigManager.config.placerImmunity, value -> {
            ConfigManager.config.placerImmunity = value;
        });
        return builder.build();
    }

    private void addBoolean(ConfigCategory category, String label, String tooltip, boolean currentValue, Consumer<Boolean> onSave) {
        category.addEntry((AbstractConfigListEntry)ConfigBuilder.create().entryBuilder().startBooleanToggle(class_2561.method_30163((String)label), currentValue).setTooltip(new class_2561[]{class_2561.method_30163((String)tooltip)}).setDefaultValue(currentValue).setSaveConsumer(onSave).build());
    }

    private void addIntField(ConfigCategory category, String label, String tooltip, int currentValue, Consumer<Integer> onSave, int min, int max) {
        category.addEntry((AbstractConfigListEntry)ConfigBuilder.create().entryBuilder().startIntField(class_2561.method_30163((String)label), currentValue).setTooltip(new class_2561[]{class_2561.method_30163((String)tooltip)}).setDefaultValue(currentValue).setSaveConsumer(newValue -> {
            if (newValue < min) {
                newValue = min;
            }
            if (newValue > max) {
                newValue = max;
            }
            onSave.accept((Integer)newValue);
            ConfigManager.saveConfig();
        }).build());
    }

    private void addFloatField(ConfigCategory category, String label, String tooltip, float currentValue, Consumer<Float> onSave, float min, float max) {
        category.addEntry((AbstractConfigListEntry)ConfigBuilder.create().entryBuilder().startFloatField(class_2561.method_30163((String)label), currentValue).setTooltip(new class_2561[]{class_2561.method_30163((String)tooltip)}).setDefaultValue(currentValue).setSaveConsumer(newValue -> {
            if (newValue.floatValue() < min) {
                newValue = Float.valueOf(min);
            }
            if (newValue.floatValue() > max) {
                newValue = Float.valueOf(max);
            }
            onSave.accept((Float)newValue);
            ConfigManager.saveConfig();
        }).build());
    }
}

