/*
 * Decompiled with CFR 0.152.
 */
package com.redlimerl.speedrunigt;

import com.google.common.collect.Sets;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.redlimerl.speedrunigt.SpeedRunIGTUpdateChecker;
import com.redlimerl.speedrunigt.api.CategoryConditionRegisterHelper;
import com.redlimerl.speedrunigt.api.SpeedRunIGTApi;
import com.redlimerl.speedrunigt.impl.CategoryRegistryImpl;
import com.redlimerl.speedrunigt.impl.ConditionsRegistryImpl;
import com.redlimerl.speedrunigt.option.SpeedRunOption;
import com.redlimerl.speedrunigt.timer.category.CustomCategoryManager;
import com.redlimerl.speedrunigt.timer.category.RunCategory;
import com.redlimerl.speedrunigt.timer.category.condition.CategoryCondition;
import com.redlimerl.speedrunigt.timer.packet.TimerPackets;
import com.redlimerl.speedrunigt.utils.FontIdentifier;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.entrypoint.EntrypointContainer;
import net.minecraft.class_2960;
import net.minecraft.server.MinecraftServer;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SpeedRunIGT
implements ModInitializer {
    public static final String MOD_ID = "speedrunigt";
    private static boolean isInitialized = false;
    public static boolean IS_CLIENT_SIDE = false;
    public static boolean IS_DEBUG_MODE = FabricLoader.getInstance().isDevelopmentEnvironment();
    public static MinecraftServer DEDICATED_SERVER = null;
    public static String DEBUG_DATA = "";
    public static String MOD_VERSION;
    public static HashMap<class_2960, FontIdentifier> FONT_MAPS;
    public static final Gson GSON;
    public static final Gson PRETTY_GSON;
    public static final Path FONT_PATH;
    public static final Set<ModContainer> API_PROVIDERS;
    private static final Logger LOGGER;

    public static boolean isInitialized() {
        return isInitialized;
    }

    public static Path getMainPath() {
        return FabricLoader.getInstance().getGameDir().resolve(MOD_ID);
    }

    public static Path getGlobalPath() {
        return new File(System.getProperty("user.home").replace("\\", "/"), MOD_ID).toPath();
    }

    public static Path getRecordsPath() {
        return SpeedRunIGT.getGlobalPath().resolve("records");
    }

    public void onInitialize() {
        MOD_VERSION = FabricLoader.getInstance().getModContainer(MOD_ID).isPresent() ? ((ModContainer)FabricLoader.getInstance().getModContainer(MOD_ID).get()).getMetadata().getVersion().getFriendlyString() : "Unknown+Unknown";
        new CategoryRegistryImpl().registerCategories().forEach(RunCategory::registerCategory);
        CategoryCondition.registerCondition(new ConditionsRegistryImpl().registerConditions());
        for (EntrypointContainer entryPoint : FabricLoader.getInstance().getEntrypointContainers(MOD_ID, SpeedRunIGTApi.class)) {
            Map<String, CategoryConditionRegisterHelper> multipleConditions;
            Collection<RunCategory> multipleCategories;
            SpeedRunIGTApi api = (SpeedRunIGTApi)entryPoint.getEntrypoint();
            RunCategory singleCategory = api.registerCategory();
            if (singleCategory != null) {
                RunCategory.registerCategory(singleCategory);
            }
            if ((multipleCategories = api.registerCategories()) != null) {
                multipleCategories.forEach(RunCategory::registerCategory);
            }
            if ((multipleConditions = api.registerConditions()) != null) {
                CategoryCondition.registerCondition(multipleConditions);
            }
            API_PROVIDERS.add(entryPoint.getProvider());
        }
        SpeedRunOption.init();
        CustomCategoryManager.init();
        isInitialized = true;
        System.setProperty("speedrunigt.version", MOD_VERSION.split("\\+")[0]);
        System.setProperty("speedrunigt.record", "");
        SpeedRunIGTUpdateChecker.checkUpdate();
        TimerPackets.init();
    }

    public static void debug(Object obj) {
        if (IS_DEBUG_MODE) {
            LOGGER.info(obj);
        }
    }

    public static void error(Object obj) {
        LOGGER.error(obj);
    }

    static {
        FONT_MAPS = new HashMap();
        GSON = new GsonBuilder().serializeNulls().disableHtmlEscaping().create();
        PRETTY_GSON = new GsonBuilder().setPrettyPrinting().serializeNulls().create();
        FONT_PATH = SpeedRunIGT.getGlobalPath().resolve("fonts");
        API_PROVIDERS = Sets.newHashSet();
        SpeedRunIGT.getMainPath().toFile().mkdirs();
        SpeedRunIGT.getGlobalPath().toFile().mkdirs();
        SpeedRunIGT.getRecordsPath().toFile().mkdirs();
        FONT_PATH.toFile().mkdirs();
        File oldWorlds = SpeedRunIGT.getMainPath().resolve("worlds").toFile();
        if (oldWorlds.exists()) {
            try {
                FileUtils.deleteDirectory((File)oldWorlds);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        LOGGER = LogManager.getLogger((String)"SpeedRunIGT");
    }
}

