/*
 * Decompiled with CFR 0.152.
 */
package com.redlimerl.speedrunigt.events;

import com.redlimerl.speedrunigt.events.Event;
import com.redlimerl.speedrunigt.instance.GameInstance;
import com.redlimerl.speedrunigt.instance.TimerWorld;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class EventRepository {
    private static final Logger LOGGER = LogManager.getLogger((String)"Event Repository");
    private final Map<String, Integer> eventVersions = new HashMap<String, Integer>();
    private final TimerWorld world;
    private final Path eventsPath;
    private final Path globalEventsPath;

    public EventRepository(TimerWorld world, Path eventsPath, Path globalEventsPath) {
        this.world = world;
        this.eventsPath = eventsPath;
        this.globalEventsPath = globalEventsPath;
    }

    public List<Event> getOldEvents() {
        List<Event> list;
        block9: {
            if (Files.notExists(this.eventsPath, new LinkOption[0]) || !Files.isRegularFile(this.eventsPath, new LinkOption[0])) {
                LOGGER.info("Couldn't load old events.");
                return new ArrayList<Event>();
            }
            Stream<String> eventStrings = Files.lines(this.eventsPath);
            try {
                list = ((Stream)eventStrings.map(eventString -> {
                    Event event = Event.parse(eventString, this.eventVersions);
                    if (event != null) {
                        this.eventVersions.put(event.id, event.version);
                    }
                    return event;
                }).unordered()).filter(Objects::nonNull).sorted(Comparator.comparing(Event::getRealTime)).collect(Collectors.toList());
                if (eventStrings == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (eventStrings != null) {
                        try {
                            eventStrings.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    LOGGER.error("Error while loading old events", (Throwable)e);
                    return new ArrayList<Event>();
                }
            }
            eventStrings.close();
        }
        return list;
    }

    private String serializeEvent(Event event) {
        boolean writeVersion;
        boolean bl = writeVersion = !event.version.equals(this.eventVersions.getOrDefault(event.id, 0));
        if (writeVersion) {
            this.eventVersions.put(event.id, event.version);
        }
        return event.serialize(writeVersion);
    }

    public void add(Event event) {
        GameInstance.SAVE_MANAGER_THREAD.submit(() -> {
            try {
                this.writeEventToLog(event);
                this.writeWorldDataToGlobalFile();
                LOGGER.info("Successfully appended to events files.");
            }
            catch (IOException e) {
                LOGGER.error("Error while writing to events files", (Throwable)e);
            }
        });
    }

    public void addOnlyToLog(Event event) {
        GameInstance.SAVE_MANAGER_THREAD.submit(() -> {
            try {
                this.writeEventToLog(event);
                LOGGER.info("Successfully appended to events file.");
            }
            catch (IOException e) {
                LOGGER.error("Error while writing to events files", (Throwable)e);
            }
        });
    }

    private void writeEventToLog(Event event) throws IOException {
        Files.write(this.eventsPath, (this.serializeEvent(event) + "\n").getBytes(Charset.defaultCharset()), StandardOpenOption.CREATE, StandardOpenOption.APPEND);
    }

    private void writeWorldDataToGlobalFile() throws IOException {
        Files.write(this.globalEventsPath, (this.world.getWorldData() + "\n").getBytes(Charset.defaultCharset()), StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING);
    }
}

