/*
 * Decompiled with CFR 0.152.
 */
package com.redlimerl.speedrunigt.gui.screen;

import com.redlimerl.speedrunigt.SpeedRunIGT;
import com.redlimerl.speedrunigt.SpeedRunIGTUpdateChecker;
import com.redlimerl.speedrunigt.api.OptionButtonFactory;
import com.redlimerl.speedrunigt.option.SpeedRunOption;
import com.redlimerl.speedrunigt.utils.ButtonWidgetHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_4265;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import net.minecraft.class_6379;

public class SpeedRunOptionScreen
extends class_437 {
    private final class_437 parent;
    private final HashMap<String, ArrayList<class_339>> categorySubButtons = new HashMap();
    private final LinkedHashMap<String, class_339> categorySelectButtons = new LinkedHashMap();
    private final HashMap<class_364, Supplier<String>> tooltips = new HashMap();
    private ButtonScrollListWidget buttonListWidget;
    private String currentSelectCategory = "";
    private int page = 0;
    private class_339 prevPageButton = null;
    private class_339 nextPageButton = null;

    public SpeedRunOptionScreen(class_437 parent) {
        super((class_2561)class_2561.method_43471((String)"speedrunigt.title.options"));
        this.parent = parent;
    }

    protected void method_25426() {
        super.method_25426();
        this.categorySubButtons.clear();
        this.categorySelectButtons.clear();
        this.tooltips.clear();
        List<OptionButtonFactory> optionButtonFactoryList = SpeedRunOption.getOptionButtonFactories();
        int categoryCount = 0;
        for (OptionButtonFactory factory : optionButtonFactoryList) {
            OptionButtonFactory.Storage builder = factory.create(this).build();
            class_339 button2 = builder.getButtonWidget();
            if (builder.getTooltip() != null) {
                this.tooltips.put((class_364)button2, builder.getTooltip());
            }
            String category = builder.getCategory();
            ArrayList<class_339> categoryList = this.categorySubButtons.getOrDefault(category, new ArrayList());
            categoryList.add(button2);
            this.categorySubButtons.put(category, categoryList);
            if (this.categorySelectButtons.containsKey(category)) continue;
            class_4185 buttonWidget = ButtonWidgetHelper.create(this.field_22789 - 110, 30 + categoryCount++ % 6 * 22, 80, 20, (class_2561)class_2561.method_43471((String)category), buttonWidget1 -> this.selectCategory(category));
            this.categorySelectButtons.put(category, (class_339)buttonWidget);
            this.method_37063((class_364)buttonWidget);
        }
        this.prevPageButton = (class_339)this.method_37063((class_364)ButtonWidgetHelper.create(this.field_22789 - 110, 162, 38, 20, (class_2561)class_2561.method_43470((String)"<"), button -> this.openPage(-1)));
        this.nextPageButton = (class_339)this.method_37063((class_364)ButtonWidgetHelper.create(this.field_22789 - 68, 162, 38, 20, (class_2561)class_2561.method_43470((String)">"), button -> this.openPage(1)));
        this.openPage(this.page);
        this.method_37063((class_364)ButtonWidgetHelper.create(this.field_22789 - 85, this.field_22790 - 35, 70, 20, class_5244.field_24335, button -> this.method_25419()));
        this.method_37063((class_364)ButtonWidgetHelper.create(15, this.field_22790 - 35, 70, 20, (class_2561)class_2561.method_43471((String)"speedrunigt.menu.donate"), button -> class_156.method_668().method_670("https://ko-fi.com/redlimerl")));
        this.method_37063((class_364)ButtonWidgetHelper.create(88, this.field_22790 - 35, 140, 20, (class_2561)class_2561.method_43471((String)"speedrunigt.menu.crowdin"), button -> class_156.method_668().method_670("https://crowdin.com/project/speedrunigt")));
        this.buttonListWidget = (ButtonScrollListWidget)this.method_25429((class_364)new ButtonScrollListWidget(this));
        if (!this.currentSelectCategory.isEmpty()) {
            this.selectCategory(this.currentSelectCategory);
        } else {
            this.categorySelectButtons.keySet().stream().findFirst().ifPresent(this::selectCategory);
        }
    }

    public void openPage(int num) {
        int maxPage = Math.max((this.categorySelectButtons.keySet().size() - 1) / 6, 0);
        this.page = class_3532.method_15340((int)(this.page + num), (int)0, (int)maxPage);
        int count = 0;
        for (class_339 value : this.categorySelectButtons.values()) {
            value.field_22764 = this.page * 6 <= count && (this.page + 1) * 6 > count;
            ++count;
        }
        if (maxPage == 0) {
            this.prevPageButton.field_22764 = false;
            this.nextPageButton.field_22764 = false;
        } else {
            this.prevPageButton.field_22764 = true;
            this.nextPageButton.field_22764 = true;
            this.prevPageButton.field_22763 = this.page != 0;
            this.nextPageButton.field_22763 = maxPage != this.page;
        }
    }

    public void method_25419() {
        if (this.field_22787 != null) {
            this.field_22787.method_1507(this.parent);
        }
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        super.method_25394(context, mouseX, mouseY, delta);
        this.buttonListWidget.method_25394(context, mouseX, mouseY, delta);
        context.method_27534(this.field_22793, this.field_22785, this.field_22789 / 2, 10, -1);
        context.method_51433(this.field_22793, "v" + SpeedRunIGT.MOD_VERSION, 4, 4, -1, true);
        ArrayList<class_2561> tooltip = this.getToolTip(mouseX, mouseY);
        if (!tooltip.isEmpty() && !this.method_25397()) {
            context.method_51434(this.field_22793, tooltip, 0, this.field_22790);
        }
    }

    public ArrayList<class_2561> getToolTip(int mouseX, int mouseY) {
        ButtonScrollListWidget.Entry entry;
        class_339 buttonWidget;
        class_364 element;
        ArrayList<class_2561> tooltipList = new ArrayList<class_2561>();
        Optional e = this.buttonListWidget.method_19355(mouseX, mouseY);
        if (e.isPresent() && (element = (class_364)e.get()) instanceof ButtonScrollListWidget.Entry && this.tooltips.containsKey(buttonWidget = (entry = (ButtonScrollListWidget.Entry)element).getButtonWidget())) {
            String text = this.tooltips.get(buttonWidget).get();
            for (String s : text.split("\n")) {
                tooltipList.add((class_2561)class_2561.method_43470((String)s));
            }
            return tooltipList;
        }
        if (SpeedRunIGTUpdateChecker.UPDATE_STATUS == SpeedRunIGTUpdateChecker.UpdateStatus.OUTDATED) {
            tooltipList.add((class_2561)class_2561.method_43471((String)"speedrunigt.message.update_found"));
        }
        return tooltipList;
    }

    public void selectCategory(String key) {
        if (this.categorySelectButtons.containsKey(key) && this.categorySubButtons.containsKey(key)) {
            if (this.categorySelectButtons.containsKey(this.currentSelectCategory)) {
                this.categorySelectButtons.get((Object)this.currentSelectCategory).field_22763 = true;
            }
            this.currentSelectCategory = key;
            this.categorySelectButtons.get((Object)key).field_22763 = false;
            this.buttonListWidget.replaceButtons((Collection<class_339>)this.categorySubButtons.get(key));
            this.buttonListWidget.method_44382(0.0);
        }
    }

    class ButtonScrollListWidget
    extends class_4265<Entry> {
        public ButtonScrollListWidget(SpeedRunOptionScreen this$0) {
            super(this$0.field_22787, this$0.field_22789 - 140, this$0.field_22790 - 82, 28, 24);
        }

        public void replaceButtons(Collection<class_339> buttonWidgets) {
            ArrayList<Entry> list = new ArrayList<Entry>();
            for (class_339 buttonWidget : buttonWidgets) {
                list.add(new Entry(this, buttonWidget));
            }
            this.method_25314(list);
        }

        public int method_25322() {
            return 150;
        }

        public void method_48579(class_332 context, int mouseX, int mouseY, float delta) {
            super.method_48579(context, mouseX, mouseY, delta);
        }

        class Entry
        extends class_4265.class_4266<Entry> {
            ArrayList<class_339> children = new ArrayList();
            private final class_339 buttonWidget;

            public Entry(ButtonScrollListWidget this$1, class_339 buttonWidget) {
                this.buttonWidget = buttonWidget;
                this.buttonWidget.method_46421((this$1.field_22758 - this.buttonWidget.method_25368()) / 2);
                this.children.add(this.buttonWidget);
            }

            public List<? extends class_364> method_25396() {
                return this.children;
            }

            public List<? extends class_6379> method_37025() {
                return this.children;
            }

            public class_339 getButtonWidget() {
                return this.buttonWidget;
            }

            public void method_25343(class_332 context, int mouseX, int mouseY, boolean hovered, float deltaTicks) {
                this.buttonWidget.method_46419(this.method_46427());
                this.buttonWidget.method_25394(context, mouseX, mouseY, deltaTicks);
            }
        }
    }
}

