/*
 * Decompiled with CFR 0.152.
 */
package com.redlimerl.speedrunigt.gui.screen;

import com.redlimerl.speedrunigt.SpeedRunIGT;
import com.redlimerl.speedrunigt.SpeedRunIGTClient;
import com.redlimerl.speedrunigt.gui.screen.FontConfigScreen;
import com.redlimerl.speedrunigt.mixins.access.FontManagerAccessor;
import com.redlimerl.speedrunigt.mixins.access.MinecraftClientAccessor;
import com.redlimerl.speedrunigt.option.SpeedRunOption;
import com.redlimerl.speedrunigt.option.SpeedRunOptions;
import com.redlimerl.speedrunigt.timer.TimerDrawer;
import com.redlimerl.speedrunigt.utils.ButtonWidgetHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import net.minecraft.class_11719;
import net.minecraft.class_11908;
import net.minecraft.class_11909;
import net.minecraft.class_124;
import net.minecraft.class_156;
import net.minecraft.class_241;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_3532;
import net.minecraft.class_357;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import net.minecraft.class_5250;
import net.minecraft.class_7919;
import net.minecraft.class_9848;

public class TimerCustomizeScreen
extends class_437 {
    private final TimerDrawer drawer = new TimerDrawer(false);
    private final class_437 parent;
    private TimerDrawer.PositionType currentPosType = TimerDrawer.PositionType.DEFAULT;
    private final HashMap<TimerDrawer.PositionType, class_241> posTypesRTA = new HashMap();
    private final HashMap<TimerDrawer.PositionType, class_241> posTypesIGT = new HashMap();
    private boolean changed = false;
    private boolean hide = false;
    private final ArrayList<class_339> tabButtons = new ArrayList();
    private final ArrayList<class_339> normalOptions = new ArrayList();
    private final ArrayList<class_339> igtOptions = new ArrayList();
    private final ArrayList<class_339> rtaOptions = new ArrayList();
    private final ArrayList<class_339> posOptions = new ArrayList();
    private final ArrayList<class_339> fontOptions = new ArrayList();
    private final ArrayList<class_339> backgroundOptions = new ArrayList();
    private class_4185 normalButton;
    private class_4185 igtButton;
    private class_4185 rtaButton;
    private class_4185 posButton;
    private class_4185 fontButton;
    private class_4185 backgroundButton;
    private class_4185 saveButton;
    private class_4185 fontConfigButton;
    private int fontPage = 0;
    private final ArrayList<class_2960> availableFonts = new ArrayList();
    private final ArrayList<class_4185> fontSelectButtons = new ArrayList();
    private boolean splitPosition = SpeedRunOption.getOption(SpeedRunOptions.ENABLE_TIMER_SPLIT_POS);
    private int currentTab = 0;

    public TimerCustomizeScreen(class_437 parent) {
        super((class_2561)class_2561.method_43471((String)"speedrunigt.option.timer_position"));
        this.parent = parent;
    }

    private void openTab(int tab) {
        this.currentTab = tab;
        this.normalButton.field_22763 = tab != 0;
        this.igtButton.field_22763 = tab != 1;
        this.rtaButton.field_22763 = tab != 2;
        this.posButton.field_22763 = tab != 5;
        this.fontButton.field_22763 = tab != 3;
        boolean bl = this.backgroundButton.field_22763 = tab != 4;
        if (this.hide) {
            return;
        }
        for (class_339 normalOption : this.normalOptions) {
            normalOption.field_22764 = tab == 0;
        }
        for (class_339 igtOption : this.igtOptions) {
            igtOption.field_22764 = tab == 1;
        }
        for (class_339 rtaOption : this.rtaOptions) {
            rtaOption.field_22764 = tab == 2;
        }
        for (class_339 fontOption : this.fontOptions) {
            fontOption.field_22764 = tab == 3;
        }
        for (class_339 backgroundOption : this.backgroundOptions) {
            backgroundOption.field_22764 = tab == 4;
        }
        for (class_339 posOption : this.posOptions) {
            posOption.field_22764 = tab == 5;
        }
        this.fontConfigButton.field_22764 = tab == 3 && Objects.equals(this.drawer.getTimerFont().method_12836(), "speedrunigt");
    }

    protected void method_25426() {
        this.normalOptions.clear();
        this.igtOptions.clear();
        this.rtaOptions.clear();
        this.posOptions.clear();
        this.fontOptions.clear();
        this.availableFonts.clear();
        this.fontSelectButtons.clear();
        this.backgroundOptions.clear();
        if (this.field_22787 != null) {
            FontManagerAccessor fontManager = (FontManagerAccessor)((MinecraftClientAccessor)this.field_22787).getFontManager();
            if (!fontManager.getFontStorages().containsKey(this.drawer.getTimerFont())) {
                this.availableFonts.add(this.drawer.getTimerFont());
            }
            this.availableFonts.addAll(fontManager.getFontStorages().keySet());
        }
        this.initNormal();
        this.initIGTButtons();
        this.initRTAButtons();
        this.initPositionButtons();
        this.initFontButtons();
        this.initBackgroundButtons();
        this.normalButton = (class_4185)this.method_37063((class_364)ButtonWidgetHelper.create(this.field_22789 / 2 - 179, this.field_22790 / 2 - 48, 58, 20, (class_2561)class_2561.method_43471((String)"options.title").method_27693("..."), button -> this.openTab(0)));
        this.tabButtons.add((class_339)this.normalButton);
        this.igtButton = (class_4185)this.method_37063((class_364)ButtonWidgetHelper.create(this.field_22789 / 2 - 119, this.field_22790 / 2 - 48, 58, 20, (class_2561)class_2561.method_43470((String)"IGT..."), button -> this.openTab(1)));
        this.tabButtons.add((class_339)this.igtButton);
        this.rtaButton = (class_4185)this.method_37063((class_364)ButtonWidgetHelper.create(this.field_22789 / 2 - 59, this.field_22790 / 2 - 48, 58, 20, (class_2561)class_2561.method_43470((String)"RTA..."), button -> this.openTab(2)));
        this.tabButtons.add((class_339)this.rtaButton);
        this.posButton = (class_4185)this.method_37063((class_364)ButtonWidgetHelper.create(this.field_22789 / 2 + 1, this.field_22790 / 2 - 48, 58, 20, (class_2561)class_2561.method_43470((String)"Pos..."), button -> this.openTab(5)));
        this.tabButtons.add((class_339)this.posButton);
        this.fontButton = (class_4185)this.method_37063((class_364)ButtonWidgetHelper.create(this.field_22789 / 2 + 61, this.field_22790 / 2 - 48, 58, 20, (class_2561)class_2561.method_43471((String)"speedrunigt.title.font"), button -> {
            this.openTab(3);
            this.openFontPage();
        }));
        this.tabButtons.add((class_339)this.fontButton);
        this.backgroundButton = (class_4185)this.method_37063((class_364)ButtonWidgetHelper.create(this.field_22789 / 2 + 121, this.field_22790 / 2 - 48, 58, 20, (class_2561)class_2561.method_43471((String)"speedrunigt.title.background"), button -> this.openTab(4)));
        this.tabButtons.add((class_339)this.backgroundButton);
        this.method_37063((class_364)ButtonWidgetHelper.create(this.field_22789 / 2 - 89, this.field_22790 / 2 + 62, 58, 20, (class_2561)class_2561.method_43471((String)"speedrunigt.option.hide"), button -> {
            this.hide = !this.hide;
            for (class_339 normalOption : this.normalOptions) {
                normalOption.field_22764 = !this.hide && this.currentTab == 0;
            }
            for (class_339 igtOption : this.igtOptions) {
                igtOption.field_22764 = !this.hide && this.currentTab == 1;
            }
            for (class_339 rtaOption : this.rtaOptions) {
                rtaOption.field_22764 = !this.hide && this.currentTab == 2;
            }
            for (class_339 posOption : this.posOptions) {
                posOption.field_22764 = !this.hide && this.currentTab == 5;
            }
            for (class_339 fontOption : this.fontOptions) {
                fontOption.field_22764 = !this.hide && this.currentTab == 3;
            }
            for (class_339 backgroundOption : this.backgroundOptions) {
                backgroundOption.field_22764 = !this.hide && this.currentTab == 4;
            }
            for (class_339 tabButton : this.tabButtons) {
                tabButton.field_22764 = !this.hide;
            }
            this.openTab(this.currentTab);
            button.method_25355((class_2561)class_2561.method_43471((String)("speedrunigt.option." + (!this.hide ? "hide" : "show"))));
        }));
        this.saveButton = (class_4185)this.method_37063((class_364)ButtonWidgetHelper.create(this.field_22789 / 2 - 29, this.field_22790 / 2 + 62, 58, 20, (class_2561)class_2561.method_43471((String)"selectWorld.edit.save"), button -> {
            SpeedRunOption.setOption(SpeedRunOptions.TIMER_IGT_SCALE, Float.valueOf(this.drawer.getIGTScale()));
            SpeedRunIGTClient.TIMER_DRAWER.setIGTScale(this.drawer.getIGTScale());
            SpeedRunOption.setOption(SpeedRunOptions.TIMER_IGT_COLOR, this.drawer.getIGTColor());
            SpeedRunIGTClient.TIMER_DRAWER.setIGTColor(this.drawer.getIGTColor());
            SpeedRunOption.setOption(SpeedRunOptions.TIMER_IGT_DECO, this.drawer.getIGTDecoration());
            SpeedRunIGTClient.TIMER_DRAWER.setIGTDecoration(this.drawer.getIGTDecoration());
            SpeedRunOption.setOption(SpeedRunOptions.TIMER_IGT_DISPLAY_ALIGN, this.drawer.getIGTDisplayAlign());
            SpeedRunIGTClient.TIMER_DRAWER.setIGTDisplayAlign(this.drawer.getIGTDisplayAlign());
            SpeedRunOption.setOption(SpeedRunOptions.TIMER_RTA_SCALE, Float.valueOf(this.drawer.getRTAScale()));
            SpeedRunIGTClient.TIMER_DRAWER.setRTAScale(this.drawer.getRTAScale());
            SpeedRunOption.setOption(SpeedRunOptions.TIMER_RTA_COLOR, this.drawer.getRTAColor());
            SpeedRunIGTClient.TIMER_DRAWER.setRTAColor(this.drawer.getRTAColor());
            SpeedRunOption.setOption(SpeedRunOptions.TIMER_RTA_DECO, this.drawer.getRTADecoration());
            SpeedRunIGTClient.TIMER_DRAWER.setRTADecoration(this.drawer.getRTADecoration());
            SpeedRunOption.setOption(SpeedRunOptions.TIMER_RTA_DISPLAY_ALIGN, this.drawer.getRTADisplayAlign());
            SpeedRunIGTClient.TIMER_DRAWER.setRTADisplayAlign(this.drawer.getRTADisplayAlign());
            SpeedRunOption.setOption(SpeedRunOptions.DISPLAY_TIME_ONLY, this.drawer.isSimplyTimer());
            SpeedRunIGTClient.TIMER_DRAWER.setSimplyTimer(this.drawer.isSimplyTimer());
            SpeedRunOption.setOption(SpeedRunOptions.LOCK_TIMER_POSITION, this.drawer.isLocked());
            SpeedRunIGTClient.TIMER_DRAWER.setLocked(this.drawer.isLocked());
            SpeedRunOption.setOption(SpeedRunOptions.DISPLAY_DECIMALS, this.drawer.getTimerDecimals());
            SpeedRunIGTClient.TIMER_DRAWER.setTimerDecimals(this.drawer.getTimerDecimals());
            SpeedRunOption.setOption(SpeedRunOptions.TIMER_TEXT_FONT, this.drawer.getTimerFont());
            SpeedRunIGTClient.TIMER_DRAWER.setTimerFont(this.drawer.getTimerFont());
            SpeedRunOption.setOption(SpeedRunOptions.BACKGROUND_OPACITY, Float.valueOf(this.drawer.getBGOpacity()));
            SpeedRunIGTClient.TIMER_DRAWER.setBGOpacity(this.drawer.getBGOpacity());
            SpeedRunOption.setOption(SpeedRunOptions.RTA_BACKGROUND_PADDING, this.drawer.getRTAPadding());
            SpeedRunIGTClient.TIMER_DRAWER.setRTAPadding(this.drawer.getRTAPadding());
            SpeedRunOption.setOption(SpeedRunOptions.IGT_BACKGROUND_PADDING, this.drawer.getIGTPadding());
            SpeedRunIGTClient.TIMER_DRAWER.setIGTPadding(this.drawer.getIGTPadding());
            for (Map.Entry<TimerDrawer.PositionType, class_241> igtPosEntry : this.posTypesIGT.entrySet()) {
                if (igtPosEntry.getKey() == TimerDrawer.PositionType.DEFAULT) {
                    SpeedRunOption.setOption(SpeedRunOptions.TIMER_IGT_POSITION_X, Float.valueOf(igtPosEntry.getValue().field_1343));
                    SpeedRunOption.setOption(SpeedRunOptions.TIMER_IGT_POSITION_Y, Float.valueOf(igtPosEntry.getValue().field_1342));
                    continue;
                }
                SpeedRunOption.setOption(igtPosEntry.getKey() == TimerDrawer.PositionType.WHILE_F3 ? SpeedRunOptions.TIMER_IGT_POSITION_FOR_F3 : SpeedRunOptions.TIMER_IGT_POSITION_FOR_PAUSE, igtPosEntry.getValue());
            }
            for (Map.Entry<TimerDrawer.PositionType, class_241> rtaPosEntry : this.posTypesRTA.entrySet()) {
                if (rtaPosEntry.getKey() == TimerDrawer.PositionType.DEFAULT) {
                    SpeedRunOption.setOption(SpeedRunOptions.TIMER_RTA_POSITION_X, Float.valueOf(rtaPosEntry.getValue().field_1343));
                    SpeedRunOption.setOption(SpeedRunOptions.TIMER_RTA_POSITION_Y, Float.valueOf(rtaPosEntry.getValue().field_1342));
                    continue;
                }
                SpeedRunOption.setOption(rtaPosEntry.getKey() == TimerDrawer.PositionType.WHILE_F3 ? SpeedRunOptions.TIMER_RTA_POSITION_FOR_F3 : SpeedRunOptions.TIMER_RTA_POSITION_FOR_PAUSE, rtaPosEntry.getValue());
            }
            SpeedRunIGTClient.TIMER_DRAWER.update();
            SpeedRunOption.setOption(SpeedRunOptions.ENABLE_TIMER_SPLIT_POS, this.splitPosition);
            this.changed = false;
        }));
        this.method_37063((class_364)ButtonWidgetHelper.create(this.field_22789 / 2 + 31, this.field_22790 / 2 + 62, 58, 20, class_5244.field_24335, button -> {
            if (this.field_22787 != null) {
                this.field_22787.method_1507(this.parent);
            }
        }));
        this.fontConfigButton.field_22764 = false;
        this.openTab(0);
    }

    public boolean method_25402(class_11909 click, boolean doubled) {
        boolean isClicked = super.method_25402(click, doubled);
        if (!isClicked && click.method_74245() == 0 && !this.drawer.isLocked()) {
            if (!this.igtButton.field_22763) {
                this.drawer.setIGT_XPos(class_3532.method_15363((float)((float)(click.comp_4798() / (double)this.field_22789)), (float)0.0f, (float)1.0f));
                this.drawer.setIGT_YPos(class_3532.method_15363((float)((float)(click.comp_4799() / (double)this.field_22790)), (float)0.0f, (float)1.0f));
                this.posTypesIGT.put(this.currentPosType, new class_241(this.drawer.getIGT_XPos(), this.drawer.getIGT_YPos()));
                this.changed = true;
            }
            if (!this.rtaButton.field_22763) {
                this.drawer.setRTA_XPos(class_3532.method_15363((float)((float)(click.comp_4798() / (double)this.field_22789)), (float)0.0f, (float)1.0f));
                this.drawer.setRTA_YPos(class_3532.method_15363((float)((float)(click.comp_4799() / (double)this.field_22790)), (float)0.0f, (float)1.0f));
                this.posTypesRTA.put(this.currentPosType, new class_241(this.drawer.getRTA_XPos(), this.drawer.getRTA_YPos()));
                this.changed = true;
            }
        }
        return isClicked;
    }

    public boolean method_25404(class_11908 input) {
        if (input.comp_4797() == 2 && input.method_74228() >= 262 && input.method_74228() <= 265 && this.field_22787 != null && !this.drawer.isLocked()) {
            int moveY;
            int moveX;
            int n = input.method_74228() == 262 ? 1 : (moveX = input.method_74228() == 263 ? -1 : 0);
            int n2 = input.method_74228() == 265 ? -1 : (moveY = input.method_74228() == 264 ? 1 : 0);
            if (!this.igtButton.field_22763) {
                this.drawer.setIGT_XPos(class_3532.method_15363((float)(this.drawer.getIGT_XPos() + (float)moveX * this.drawer.getIGTScale() / (float)this.field_22787.method_22683().method_4486()), (float)0.0f, (float)1.0f));
                this.drawer.setIGT_YPos(class_3532.method_15363((float)(this.drawer.getIGT_YPos() + (float)moveY * this.drawer.getIGTScale() / (float)this.field_22787.method_22683().method_4502()), (float)0.0f, (float)1.0f));
                this.posTypesIGT.put(this.currentPosType, new class_241(this.drawer.getIGT_XPos(), this.drawer.getIGT_YPos()));
                this.changed = true;
            }
            if (!this.rtaButton.field_22763) {
                this.drawer.setRTA_XPos(class_3532.method_15363((float)(this.drawer.getRTA_XPos() + (float)moveX * this.drawer.getRTAScale() / (float)this.field_22787.method_22683().method_4486()), (float)0.0f, (float)1.0f));
                this.drawer.setRTA_YPos(class_3532.method_15363((float)(this.drawer.getRTA_YPos() + (float)moveY * this.drawer.getRTAScale() / (float)this.field_22787.method_22683().method_4502()), (float)0.0f, (float)1.0f));
                this.posTypesRTA.put(this.currentPosType, new class_241(this.drawer.getRTA_XPos(), this.drawer.getRTA_YPos()));
                this.changed = true;
            }
            this.method_25395(null);
        }
        return super.method_25404(input);
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        super.method_25394(context, mouseX, mouseY, delta);
        this.saveButton.field_22763 = this.changed;
        this.drawer.draw(context);
        context.method_27534(this.field_22793, this.field_22785, this.field_22789 / 2, 15, -1);
        if (!this.hide) {
            if (!this.igtButton.field_22763 || !this.rtaButton.field_22763) {
                if (this.drawer.isLocked()) {
                    context.method_27534(this.field_22793, (class_2561)class_2561.method_43471((String)"speedrunigt.option.timer_position.description.lock"), this.field_22789 / 2, this.field_22790 / 2 - 80, -1);
                } else {
                    context.method_27534(this.field_22793, (class_2561)class_2561.method_43471((String)"speedrunigt.option.timer_position.description"), this.field_22789 / 2, this.field_22790 / 2 - 80, -1);
                    context.method_27534(this.field_22793, (class_2561)class_2561.method_43471((String)"speedrunigt.option.timer_position.description.move"), this.field_22789 / 2, this.field_22790 / 2 - 69, -1);
                }
            }
            if (!this.fontButton.field_22763 && this.field_22787 != null) {
                int c = this.fontPage * 3;
                FontManagerAccessor fontManager = (FontManagerAccessor)((MinecraftClientAccessor)this.field_22787).getFontManager();
                for (int i = 0; i < this.fontSelectButtons.size(); ++i) {
                    if (c + i >= this.availableFonts.size()) continue;
                    class_2960 fontIdentifier = this.availableFonts.get(c + i);
                    class_5250 text = class_2561.method_43470((String)fontIdentifier.method_12832());
                    if (this.field_22787 != null && fontManager.getFontStorages().containsKey(fontIdentifier) && !SpeedRunOption.getOption(SpeedRunOptions.CUSTOM_FONT_SAFE_MODE).booleanValue()) {
                        text.method_10862(text.method_10866().method_27704((class_11719)new class_11719.class_11721(fontIdentifier)));
                    } else {
                        text.method_10852((class_2561)class_2561.method_43470((String)" (Unavailable)")).method_27692(class_124.field_1061);
                    }
                    if (fontIdentifier.toString().equals(this.drawer.getTimerFont().toString())) {
                        text.method_27693(" [Selected]").method_27692(class_124.field_1056);
                    }
                    context.method_27534(this.field_22793, (class_2561)text, this.field_22789 / 2 - 30, this.field_22790 / 2 - 11 + i * 22, -1);
                }
            }
        }
    }

    public void method_25419() {
        assert (this.field_22787 != null);
        this.field_22787.method_1507(this.parent);
    }

    private void refreshPosition() {
        class_241 igtPos;
        if (this.posTypesIGT.containsKey((Object)this.currentPosType)) {
            igtPos = this.posTypesIGT.get((Object)this.currentPosType);
        } else {
            class_241 class_2412 = this.currentPosType == TimerDrawer.PositionType.DEFAULT ? new class_241(SpeedRunOption.getOption(SpeedRunOptions.TIMER_IGT_POSITION_X).floatValue(), SpeedRunOption.getOption(SpeedRunOptions.TIMER_IGT_POSITION_Y).floatValue()) : (igtPos = SpeedRunOption.getOption(this.currentPosType == TimerDrawer.PositionType.WHILE_F3 ? SpeedRunOptions.TIMER_IGT_POSITION_FOR_F3 : SpeedRunOptions.TIMER_IGT_POSITION_FOR_PAUSE));
        }
        class_241 rtaPos = this.posTypesRTA.containsKey((Object)this.currentPosType) ? this.posTypesRTA.get((Object)this.currentPosType) : (this.currentPosType == TimerDrawer.PositionType.DEFAULT ? new class_241(SpeedRunOption.getOption(SpeedRunOptions.TIMER_RTA_POSITION_X).floatValue(), SpeedRunOption.getOption(SpeedRunOptions.TIMER_RTA_POSITION_Y).floatValue()) : SpeedRunOption.getOption(this.currentPosType == TimerDrawer.PositionType.WHILE_F3 ? SpeedRunOptions.TIMER_RTA_POSITION_FOR_F3 : SpeedRunOptions.TIMER_RTA_POSITION_FOR_PAUSE));
        this.drawer.setIGT_XPos(igtPos.field_1343);
        this.drawer.setIGT_YPos(igtPos.field_1342);
        this.drawer.setRTA_XPos(rtaPos.field_1343);
        this.drawer.setRTA_YPos(rtaPos.field_1342);
    }

    public void initNormal() {
        this.normalOptions.add((class_339)this.method_37063((class_364)ButtonWidgetHelper.create(this.field_22789 / 2 - 80, this.field_22790 / 2 - 16, 160, 20, (class_2561)class_2561.method_43471((String)"speedrunigt.option.timer_position.show_time_only").method_27693(" : ").method_10852(this.drawer.isSimplyTimer() ? class_5244.field_24332 : class_5244.field_24333), button -> {
            this.drawer.setSimplyTimer(!this.drawer.isSimplyTimer());
            this.changed = true;
            button.method_25355((class_2561)class_2561.method_43471((String)"speedrunigt.option.timer_position.show_time_only").method_27693(" : ").method_10852(this.drawer.isSimplyTimer() ? class_5244.field_24332 : class_5244.field_24333));
        })));
        this.normalOptions.add((class_339)this.method_37063((class_364)ButtonWidgetHelper.create(this.field_22789 / 2 - 80, this.field_22790 / 2 + 6, 160, 20, (class_2561)class_2561.method_43471((String)"speedrunigt.option.timer_position.lock_timer_position").method_27693(" : ").method_10852(this.drawer.isLocked() ? class_5244.field_24332 : class_5244.field_24333), button -> {
            this.drawer.setLocked(!this.drawer.isLocked());
            this.changed = true;
            button.method_25355((class_2561)class_2561.method_43471((String)"speedrunigt.option.timer_position.lock_timer_position").method_27693(" : ").method_10852(this.drawer.isLocked() ? class_5244.field_24332 : class_5244.field_24333));
        })));
        this.normalOptions.add((class_339)this.method_37063((class_364)ButtonWidgetHelper.create(this.field_22789 / 2 - 80, this.field_22790 / 2 + 28, 160, 20, (class_2561)class_2561.method_43471((String)"speedrunigt.option.timer_position.show_decimals").method_27693(" : ").method_10852((class_2561)class_2561.method_43469((String)"speedrunigt.option.timer_position.show_decimals.context", (Object[])new Object[]{this.drawer.getTimerDecimals().getNumber()})), button -> {
            int order = this.drawer.getTimerDecimals().ordinal();
            this.drawer.setTimerDecimals(SpeedRunOptions.TimerDecimals.values()[++order % SpeedRunOptions.TimerDecimals.values().length]);
            this.changed = true;
            button.method_25355((class_2561)class_2561.method_43471((String)"speedrunigt.option.timer_position.show_decimals").method_27693(" : ").method_10852((class_2561)class_2561.method_43469((String)"speedrunigt.option.timer_position.show_decimals.context", (Object[])new Object[]{this.drawer.getTimerDecimals().getNumber()})));
        }, class_7919.method_47407((class_2561)class_2561.method_43471((String)"speedrunigt.option.timer_position.show_decimals.description")))));
    }

    public void initIGTButtons() {
        this.igtOptions.add((class_339)this.method_37063((class_364)new class_357(this.field_22789 / 2 - 127, this.field_22790 / 2 - 16, 120, 20, (class_2561)class_2561.method_43469((String)"speedrunigt.option.timer_position.color_red", (Object[])new Object[]{"IGT"}).method_27693(" : ").method_27693(String.valueOf(class_9848.method_61327((int)this.drawer.getIGTColor()))), (float)class_9848.method_61327((int)this.drawer.getIGTColor()) / 255.0f){

            protected void method_25346() {
                this.method_25355((class_2561)class_2561.method_43469((String)"speedrunigt.option.timer_position.color_red", (Object[])new Object[]{"IGT"}).method_27693(" : ").method_27693(String.valueOf(class_9848.method_61327((int)TimerCustomizeScreen.this.drawer.getIGTColor()))));
            }

            protected void method_25344() {
                int color = TimerCustomizeScreen.this.drawer.getIGTColor();
                TimerCustomizeScreen.this.drawer.setIGTColor(class_9848.method_61324((int)class_9848.method_61320((int)color), (int)((int)(this.field_22753 * 255.0)), (int)class_9848.method_61329((int)color), (int)class_9848.method_61331((int)color)));
                TimerCustomizeScreen.this.changed = true;
            }
        }));
        this.igtOptions.add((class_339)this.method_37063((class_364)new class_357(this.field_22789 / 2 - 127, this.field_22790 / 2 + 6, 120, 20, (class_2561)class_2561.method_43469((String)"speedrunigt.option.timer_position.color_green", (Object[])new Object[]{"IGT"}).method_27693(" : ").method_27693(String.valueOf(class_9848.method_61329((int)this.drawer.getIGTColor()))), (float)class_9848.method_61329((int)this.drawer.getIGTColor()) / 255.0f){

            protected void method_25346() {
                this.method_25355((class_2561)class_2561.method_43469((String)"speedrunigt.option.timer_position.color_green", (Object[])new Object[]{"IGT"}).method_27693(" : ").method_27693(String.valueOf(class_9848.method_61329((int)TimerCustomizeScreen.this.drawer.getIGTColor()))));
            }

            protected void method_25344() {
                int color = TimerCustomizeScreen.this.drawer.getIGTColor();
                TimerCustomizeScreen.this.drawer.setIGTColor(class_9848.method_61324((int)class_9848.method_61320((int)color), (int)class_9848.method_61327((int)color), (int)((int)(this.field_22753 * 255.0)), (int)class_9848.method_61331((int)color)));
                TimerCustomizeScreen.this.changed = true;
            }
        }));
        this.igtOptions.add((class_339)this.method_37063((class_364)new class_357(this.field_22789 / 2 - 127, this.field_22790 / 2 + 28, 120, 20, (class_2561)class_2561.method_43469((String)"speedrunigt.option.timer_position.color_blue", (Object[])new Object[]{"IGT"}).method_27693(" : ").method_27693(String.valueOf(class_9848.method_61331((int)this.drawer.getIGTColor()))), (float)class_9848.method_61331((int)this.drawer.getIGTColor()) / 255.0f){

            protected void method_25346() {
                this.method_25355((class_2561)class_2561.method_43469((String)"speedrunigt.option.timer_position.color_blue", (Object[])new Object[]{"IGT"}).method_27693(" : ").method_27693(String.valueOf(class_9848.method_61331((int)TimerCustomizeScreen.this.drawer.getIGTColor()))));
            }

            protected void method_25344() {
                int color = TimerCustomizeScreen.this.drawer.getIGTColor();
                TimerCustomizeScreen.this.drawer.setIGTColor(class_9848.method_61324((int)class_9848.method_61320((int)color), (int)class_9848.method_61327((int)color), (int)class_9848.method_61329((int)color), (int)((int)(this.field_22753 * 255.0))));
                TimerCustomizeScreen.this.changed = true;
            }
        }));
        this.igtOptions.add((class_339)this.method_37063((class_364)new class_357(this.field_22789 / 2 + 6, this.field_22790 / 2 - 16, 120, 20, (class_2561)class_2561.method_43469((String)"speedrunigt.option.timer_position.scale", (Object[])new Object[]{"IGT"}).method_27693(" : ").method_27693(Math.round(this.drawer.getIGTScale() * 100.0f) + "%"), this.drawer.getIGTScale() / 3.0f){

            protected void method_25346() {
                this.method_25355((class_2561)class_2561.method_43469((String)"speedrunigt.option.timer_position.scale", (Object[])new Object[]{"IGT"}).method_27693(" : ").method_27693(Math.round(TimerCustomizeScreen.this.drawer.getIGTScale() * 100.0f) + "%"));
            }

            protected void method_25344() {
                TimerCustomizeScreen.this.drawer.setIGTScale((float)Math.round((float)this.field_22753 * 3.0f * 20.0f) / 20.0f);
                TimerCustomizeScreen.this.changed = true;
            }
        }));
        this.igtOptions.add((class_339)this.method_37063((class_364)ButtonWidgetHelper.create(this.field_22789 / 2 + 6, this.field_22790 / 2 + 6, 120, 20, (class_2561)class_2561.method_43469((String)"speedrunigt.option.timer_position.text_decorate", (Object[])new Object[]{"IGT"}).method_27693(" : ").method_10852((class_2561)class_2561.method_43471((String)("speedrunigt.option.timer_position.text_decorate." + this.drawer.getIGTDecoration().name().toLowerCase(Locale.ROOT)))), button -> {
            int order = this.drawer.getIGTDecoration().ordinal();
            this.drawer.setIGTDecoration(SpeedRunOptions.TimerDecoration.values()[++order % SpeedRunOptions.TimerDecoration.values().length]);
            this.changed = true;
            button.method_25355((class_2561)class_2561.method_43469((String)"speedrunigt.option.timer_position.text_decorate", (Object[])new Object[]{"IGT"}).method_27693(" : ").method_10852((class_2561)class_2561.method_43471((String)("speedrunigt.option.timer_position.text_decorate." + this.drawer.getIGTDecoration().name().toLowerCase(Locale.ROOT)))));
        })));
        this.igtOptions.add((class_339)this.method_37063((class_364)ButtonWidgetHelper.create(this.field_22789 / 2 + 6, this.field_22790 / 2 + 28, 120, 20, (class_2561)class_2561.method_43469((String)"speedrunigt.option.timer_position.align", (Object[])new Object[]{"IGT"}).method_27693(" : ").method_10852((class_2561)class_2561.method_43471((String)("speedrunigt.option.timer_position.align." + this.drawer.getIGTDisplayAlign().name().toLowerCase(Locale.ROOT)))), button -> {
            int order = this.drawer.getIGTDisplayAlign().ordinal();
            this.drawer.setIGTDisplayAlign(SpeedRunOptions.TimerDisplayAlign.values()[++order % SpeedRunOptions.TimerDisplayAlign.values().length]);
            this.changed = true;
            button.method_25355((class_2561)class_2561.method_43469((String)"speedrunigt.option.timer_position.align", (Object[])new Object[]{"IGT"}).method_27693(" : ").method_10852((class_2561)class_2561.method_43471((String)("speedrunigt.option.timer_position.align." + this.drawer.getIGTDisplayAlign().name().toLowerCase(Locale.ROOT)))));
        })));
    }

    public void initRTAButtons() {
        this.rtaOptions.add((class_339)this.method_37063((class_364)new class_357(this.field_22789 / 2 - 127, this.field_22790 / 2 - 16, 120, 20, (class_2561)class_2561.method_43469((String)"speedrunigt.option.timer_position.color_red", (Object[])new Object[]{"RTA"}).method_27693(" : ").method_27693(String.valueOf(class_9848.method_61327((int)this.drawer.getRTAColor()))), (float)class_9848.method_61327((int)this.drawer.getRTAColor()) / 255.0f){

            protected void method_25346() {
                this.method_25355((class_2561)class_2561.method_43469((String)"speedrunigt.option.timer_position.color_red", (Object[])new Object[]{"RTA"}).method_27693(" : ").method_27693(String.valueOf(class_9848.method_61327((int)TimerCustomizeScreen.this.drawer.getRTAColor()))));
            }

            protected void method_25344() {
                int color = TimerCustomizeScreen.this.drawer.getRTAColor();
                TimerCustomizeScreen.this.drawer.setRTAColor(class_9848.method_61324((int)class_9848.method_61320((int)color), (int)((int)(this.field_22753 * 255.0)), (int)class_9848.method_61329((int)color), (int)class_9848.method_61331((int)color)));
                TimerCustomizeScreen.this.changed = true;
            }
        }));
        this.rtaOptions.add((class_339)this.method_37063((class_364)new class_357(this.field_22789 / 2 - 127, this.field_22790 / 2 + 6, 120, 20, (class_2561)class_2561.method_43469((String)"speedrunigt.option.timer_position.color_green", (Object[])new Object[]{"RTA"}).method_27693(" : ").method_27693(String.valueOf(class_9848.method_61329((int)this.drawer.getRTAColor()))), (float)class_9848.method_61329((int)this.drawer.getRTAColor()) / 255.0f){

            protected void method_25346() {
                this.method_25355((class_2561)class_2561.method_43469((String)"speedrunigt.option.timer_position.color_green", (Object[])new Object[]{"RTA"}).method_27693(" : ").method_27693(String.valueOf(class_9848.method_61329((int)TimerCustomizeScreen.this.drawer.getRTAColor()))));
            }

            protected void method_25344() {
                int color = TimerCustomizeScreen.this.drawer.getRTAColor();
                TimerCustomizeScreen.this.drawer.setRTAColor(class_9848.method_61324((int)class_9848.method_61320((int)color), (int)class_9848.method_61327((int)color), (int)((int)(this.field_22753 * 255.0)), (int)class_9848.method_61331((int)color)));
                TimerCustomizeScreen.this.changed = true;
            }
        }));
        this.rtaOptions.add((class_339)this.method_37063((class_364)new class_357(this.field_22789 / 2 - 127, this.field_22790 / 2 + 28, 120, 20, (class_2561)class_2561.method_43469((String)"speedrunigt.option.timer_position.color_blue", (Object[])new Object[]{"RTA"}).method_27693(" : ").method_27693(String.valueOf(class_9848.method_61331((int)this.drawer.getRTAColor()))), (float)class_9848.method_61331((int)this.drawer.getRTAColor()) / 255.0f){

            protected void method_25346() {
                this.method_25355((class_2561)class_2561.method_43469((String)"speedrunigt.option.timer_position.color_blue", (Object[])new Object[]{"RTA"}).method_27693(" : ").method_27693(String.valueOf(class_9848.method_61331((int)TimerCustomizeScreen.this.drawer.getRTAColor()))));
            }

            protected void method_25344() {
                int color = TimerCustomizeScreen.this.drawer.getRTAColor();
                TimerCustomizeScreen.this.drawer.setRTAColor(class_9848.method_61324((int)class_9848.method_61320((int)color), (int)class_9848.method_61327((int)color), (int)class_9848.method_61329((int)color), (int)((int)(this.field_22753 * 255.0))));
                TimerCustomizeScreen.this.changed = true;
            }
        }));
        this.rtaOptions.add((class_339)this.method_37063((class_364)new class_357(this.field_22789 / 2 + 6, this.field_22790 / 2 - 16, 120, 20, (class_2561)class_2561.method_43469((String)"speedrunigt.option.timer_position.scale", (Object[])new Object[]{"RTA"}).method_27693(" : ").method_27693(Math.round(this.drawer.getRTAScale() * 100.0f) + "%"), this.drawer.getRTAScale() / 3.0f){

            protected void method_25346() {
                this.method_25355((class_2561)class_2561.method_43469((String)"speedrunigt.option.timer_position.scale", (Object[])new Object[]{"RTA"}).method_27693(" : ").method_27693(Math.round(TimerCustomizeScreen.this.drawer.getRTAScale() * 100.0f) + "%"));
            }

            protected void method_25344() {
                TimerCustomizeScreen.this.drawer.setRTAScale((float)Math.round((float)this.field_22753 * 3.0f * 20.0f) / 20.0f);
                TimerCustomizeScreen.this.changed = true;
            }
        }));
        this.rtaOptions.add((class_339)this.method_37063((class_364)ButtonWidgetHelper.create(this.field_22789 / 2 + 6, this.field_22790 / 2 + 6, 120, 20, (class_2561)class_2561.method_43469((String)"speedrunigt.option.timer_position.text_decorate", (Object[])new Object[]{"RTA"}).method_27693(" : ").method_10852((class_2561)class_2561.method_43471((String)("speedrunigt.option.timer_position.text_decorate." + this.drawer.getRTADecoration().name().toLowerCase(Locale.ROOT)))), button -> {
            int order = this.drawer.getRTADecoration().ordinal();
            this.drawer.setRTADecoration(SpeedRunOptions.TimerDecoration.values()[++order % SpeedRunOptions.TimerDecoration.values().length]);
            this.changed = true;
            button.method_25355((class_2561)class_2561.method_43469((String)"speedrunigt.option.timer_position.text_decorate", (Object[])new Object[]{"RTA"}).method_27693(" : ").method_10852((class_2561)class_2561.method_43471((String)("speedrunigt.option.timer_position.text_decorate." + this.drawer.getRTADecoration().name().toLowerCase(Locale.ROOT)))));
        })));
        this.rtaOptions.add((class_339)this.method_37063((class_364)ButtonWidgetHelper.create(this.field_22789 / 2 + 6, this.field_22790 / 2 + 28, 120, 20, (class_2561)class_2561.method_43469((String)"speedrunigt.option.timer_position.align", (Object[])new Object[]{"RTA"}).method_27693(" : ").method_10852((class_2561)class_2561.method_43471((String)("speedrunigt.option.timer_position.align." + this.drawer.getRTADisplayAlign().name().toLowerCase(Locale.ROOT)))), button -> {
            int order = this.drawer.getRTADisplayAlign().ordinal();
            this.drawer.setRTADisplayAlign(SpeedRunOptions.TimerDisplayAlign.values()[++order % SpeedRunOptions.TimerDisplayAlign.values().length]);
            this.changed = true;
            button.method_25355((class_2561)class_2561.method_43469((String)"speedrunigt.option.timer_position.align", (Object[])new Object[]{"RTA"}).method_27693(" : ").method_10852((class_2561)class_2561.method_43471((String)("speedrunigt.option.timer_position.align." + this.drawer.getRTADisplayAlign().name().toLowerCase(Locale.ROOT)))));
        })));
    }

    public void initPositionButtons() {
        class_4185 posTypeButton = (class_4185)this.method_37063((class_364)ButtonWidgetHelper.create(this.field_22789 / 2 - 80, this.field_22790 / 2 + 6, 160, 20, (class_2561)class_2561.method_43471((String)"speedrunigt.option.timer_position.split_position_type").method_27693(" : ").method_10852((class_2561)class_2561.method_43471((String)("speedrunigt.option.timer_position.split_position_type." + this.currentPosType.name().toLowerCase(Locale.ROOT)))), button -> {
            int order = (this.currentPosType.ordinal() + 1) % TimerDrawer.PositionType.values().length;
            this.currentPosType = TimerDrawer.PositionType.values()[order];
            this.changed = true;
            this.refreshPosition();
            button.method_25355((class_2561)class_2561.method_43471((String)"speedrunigt.option.timer_position.split_position_type").method_27693(" : ").method_10852((class_2561)class_2561.method_43471((String)("speedrunigt.option.timer_position.split_position_type." + this.currentPosType.name().toLowerCase(Locale.ROOT)))));
        }));
        posTypeButton.field_22763 = this.splitPosition;
        this.posOptions.add((class_339)this.method_37063((class_364)ButtonWidgetHelper.create(this.field_22789 / 2 - 80, this.field_22790 / 2 - 16, 160, 20, (class_2561)class_2561.method_43471((String)"speedrunigt.option.timer_position.split_position").method_27693(" : ").method_10852(this.splitPosition ? class_5244.field_24332 : class_5244.field_24333), button -> {
            this.splitPosition = !this.splitPosition;
            this.changed = true;
            posTypeButton.field_22763 = this.splitPosition;
            button.method_25355((class_2561)class_2561.method_43471((String)"speedrunigt.option.timer_position.split_position").method_27693(" : ").method_10852(this.splitPosition ? class_5244.field_24332 : class_5244.field_24333));
            if (!this.splitPosition) {
                this.currentPosType = TimerDrawer.PositionType.DEFAULT;
                this.refreshPosition();
                posTypeButton.method_25355((class_2561)class_2561.method_43471((String)"speedrunigt.option.timer_position.split_position_type").method_27693(" : ").method_10852((class_2561)class_2561.method_43471((String)("speedrunigt.option.timer_position.split_position_type." + this.currentPosType.name().toLowerCase(Locale.ROOT)))));
            }
        })));
        this.posOptions.add((class_339)posTypeButton);
    }

    public void initFontButtons() {
        class_4185 prevButton = (class_4185)this.method_37063((class_364)ButtonWidgetHelper.create(this.field_22789 / 2 - 180, this.field_22790 / 2 + 6, 20, 20, (class_2561)class_2561.method_43470((String)"<"), button -> {
            --this.fontPage;
            this.openFontPage();
        }));
        class_4185 nextButton = (class_4185)this.method_37063((class_364)ButtonWidgetHelper.create(this.field_22789 / 2 + 180, this.field_22790 / 2 + 6, 20, 20, (class_2561)class_2561.method_43470((String)">"), button -> {
            ++this.fontPage;
            this.openFontPage();
        }));
        this.fontOptions.add((class_339)prevButton);
        this.fontOptions.add((class_339)nextButton);
        this.fontSelectButtons.add((class_4185)this.method_37063((class_364)ButtonWidgetHelper.create(this.field_22789 / 2 + 35, this.field_22790 / 2 - 16, 50, 20, (class_2561)class_2561.method_43471((String)"speedrunigt.option.select"), button -> {
            int c = this.fontPage * 3;
            if (this.availableFonts.size() > c) {
                for (class_4185 fontSelectButton : this.fontSelectButtons) {
                    fontSelectButton.field_22763 = true;
                }
                this.drawer.setTimerFont(this.availableFonts.get(c));
                button.field_22763 = false;
                this.openFontPage();
                this.changed = true;
            }
        })));
        this.fontSelectButtons.add((class_4185)this.method_37063((class_364)ButtonWidgetHelper.create(this.field_22789 / 2 + 35, this.field_22790 / 2 + 6, 50, 20, (class_2561)class_2561.method_43471((String)"speedrunigt.option.select"), button -> {
            int c = this.fontPage * 3 + 1;
            if (this.availableFonts.size() > c) {
                for (class_4185 fontSelectButton : this.fontSelectButtons) {
                    fontSelectButton.field_22763 = true;
                }
                this.drawer.setTimerFont(this.availableFonts.get(c));
                button.field_22763 = false;
                this.openFontPage();
                this.changed = true;
            }
        })));
        this.fontSelectButtons.add((class_4185)this.method_37063((class_364)ButtonWidgetHelper.create(this.field_22789 / 2 + 35, this.field_22790 / 2 + 28, 50, 20, (class_2561)class_2561.method_43471((String)"speedrunigt.option.select"), button -> {
            int c = this.fontPage * 3 + 2;
            if (this.availableFonts.size() > c) {
                for (class_4185 fontSelectButton : this.fontSelectButtons) {
                    fontSelectButton.field_22763 = true;
                }
                this.drawer.setTimerFont(this.availableFonts.get(c));
                button.field_22763 = false;
                this.openFontPage();
                this.changed = true;
            }
        })));
        for (class_339 fontOption : this.fontOptions) {
            fontOption.field_22764 = false;
        }
        for (class_4185 fontSelectButton : this.fontSelectButtons) {
            fontSelectButton.field_22764 = false;
        }
        this.fontOptions.addAll(this.fontSelectButtons);
        this.fontConfigButton = (class_4185)this.method_37063((class_364)ButtonWidgetHelper.create(this.field_22789 / 2 + 88, 0, 50, 20, (class_2561)class_2561.method_43470((String)"Config"), button -> {
            if (this.field_22787 != null) {
                this.field_22787.method_1507((class_437)new FontConfigScreen(this, this.drawer.getTimerFont()));
            }
        }));
        this.fontOptions.add((class_339)this.method_37063((class_364)ButtonWidgetHelper.create(this.field_22789 / 2 - 154, this.field_22790 / 2 - 80, 150, 20, (class_2561)class_2561.method_43471((String)"speedrunigt.option.timer_position.font.open_folder"), button -> class_156.method_668().method_672(SpeedRunIGT.FONT_PATH.toFile()))));
        this.fontOptions.add((class_339)this.method_37063((class_364)ButtonWidgetHelper.create(this.field_22789 / 2 + 4, this.field_22790 / 2 - 80, 150, 20, (class_2561)class_2561.method_43471((String)"speedrunigt.option.timer_position.font.description"), button -> class_156.method_668().method_670("https://youtu.be/agBbiTQWj78"))));
        this.openFontPage();
    }

    public void openFontPage() {
        this.fontOptions.get((int)0).field_22763 = this.fontPage != 0;
        this.fontOptions.get((int)1).field_22763 = this.fontPage != Math.max((this.availableFonts.size() - 1) / 3, 0);
        int c = this.fontPage * 3;
        int available = 0;
        for (int i = 0; i < this.fontSelectButtons.size(); ++i) {
            class_4185 button = this.fontSelectButtons.get(i);
            if (c + i < this.availableFonts.size()) {
                boolean bl = button.field_22763 = !this.availableFonts.get(c + i).toString().equals(this.drawer.getTimerFont().toString());
                if (!button.field_22763 && Objects.equals(this.drawer.getTimerFont().method_12836(), "speedrunigt")) {
                    available = button.method_46427();
                }
                button.field_22764 = true;
                continue;
            }
            button.field_22764 = false;
        }
        this.fontConfigButton.field_22764 = this.currentTab == 3 && available != 0;
        this.fontConfigButton.method_46419(available);
    }

    public void initBackgroundButtons() {
        this.backgroundOptions.add((class_339)this.method_37063((class_364)new class_357(this.field_22789 / 2 - 80, this.field_22790 / 2 - 16, 160, 20, (class_2561)class_2561.method_43471((String)"speedrunigt.option.timer_position.background_opacity").method_27693(" : ").method_27693((int)(this.drawer.getBGOpacity() * 100.0f) + "%"), this.drawer.getBGOpacity()){

            protected void method_25346() {
                this.method_25355((class_2561)class_2561.method_43471((String)"speedrunigt.option.timer_position.background_opacity").method_27693(" : ").method_27693((int)(TimerCustomizeScreen.this.drawer.getBGOpacity() * 100.0f) + "%"));
            }

            protected void method_25344() {
                TimerCustomizeScreen.this.drawer.setBGOpacity((float)this.field_22753);
                TimerCustomizeScreen.this.changed = true;
            }
        }));
        this.backgroundOptions.add((class_339)this.method_37063((class_364)new class_357(this.field_22789 / 2 - 80, this.field_22790 / 2 + 6, 160, 20, (class_2561)class_2561.method_43469((String)"speedrunigt.option.timer_position.background_padding", (Object[])new Object[]{"RTA"}).method_27693(" : ").method_27693(String.valueOf(this.drawer.getRTAPadding())), (float)(this.drawer.getRTAPadding() - 1) / 24.0f){

            protected void method_25346() {
                this.method_25355((class_2561)class_2561.method_43469((String)"speedrunigt.option.timer_position.background_padding", (Object[])new Object[]{"RTA"}).method_27693(" : ").method_27693(String.valueOf(TimerCustomizeScreen.this.drawer.getRTAPadding())));
            }

            protected void method_25344() {
                TimerCustomizeScreen.this.drawer.setRTAPadding((int)(this.field_22753 * 24.0) + 1);
                TimerCustomizeScreen.this.changed = true;
            }
        }));
        this.backgroundOptions.add((class_339)this.method_37063((class_364)new class_357(this.field_22789 / 2 - 80, this.field_22790 / 2 + 28, 160, 20, (class_2561)class_2561.method_43469((String)"speedrunigt.option.timer_position.background_padding", (Object[])new Object[]{"IGT"}).method_27693(" : ").method_27693(String.valueOf(this.drawer.getIGTPadding())), (float)(this.drawer.getIGTPadding() - 1) / 24.0f){

            protected void method_25346() {
                this.method_25355((class_2561)class_2561.method_43469((String)"speedrunigt.option.timer_position.background_padding", (Object[])new Object[]{"IGT"}).method_27693(" : ").method_27693(String.valueOf(TimerCustomizeScreen.this.drawer.getIGTPadding())));
            }

            protected void method_25344() {
                TimerCustomizeScreen.this.drawer.setIGTPadding((int)(this.field_22753 * 24.0) + 1);
                TimerCustomizeScreen.this.changed = true;
            }
        }));
    }
}

