/*
 * Decompiled with CFR 0.152.
 */
package com.redlimerl.speedrunigt.instance;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.redlimerl.speedrunigt.SpeedRunIGT;
import com.redlimerl.speedrunigt.events.EventRepository;
import com.redlimerl.speedrunigt.timer.InGameTimer;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_155;
import net.minecraft.class_6489;

public class TimerWorld {
    private static final Gson GSON = new Gson();
    private static final String EVENT_LOG_FILE_NAME = "events.log";
    private final Path worldFolderPath;
    private final List<String> mods;
    private final class_6489 version;
    private final EventRepository eventRepository;

    TimerWorld(Path worldFolderPath, Path globalEventsPath) {
        this.worldFolderPath = worldFolderPath;
        this.mods = FabricLoader.getInstance().getAllMods().stream().map(mod -> mod.getMetadata().getId()).collect(Collectors.toList());
        this.version = class_155.method_16673();
        this.eventRepository = new EventRepository(this, this.worldFolderPath.resolve(EVENT_LOG_FILE_NAME), globalEventsPath);
    }

    public String getWorldData() {
        return GSON.toJson((JsonElement)this.getWorldDataObject());
    }

    private JsonObject getWorldDataObject() {
        JsonObject object = new JsonObject();
        JsonArray modsArray = new JsonArray();
        this.mods.forEach(arg_0 -> ((JsonArray)modsArray).add(arg_0));
        object.addProperty("world_path", this.worldFolderPath.getParent().toString().replace("\\", "/"));
        object.add("mods", (JsonElement)modsArray);
        object.addProperty("version", this.version.comp_4025());
        object.addProperty("mod_version", SpeedRunIGT.MOD_VERSION);
        object.addProperty("category", InGameTimer.getInstance().getCategory().getID());
        return object;
    }

    public EventRepository getEventRepository() {
        return this.eventRepository;
    }

    public Set<UUID> getPreviousPlayers() {
        try {
            return Arrays.stream(Objects.requireNonNull(this.worldFolderPath.resolveSibling("stats").toFile().list())).map(s -> UUID.fromString(s.split("\\.")[0])).collect(Collectors.toSet());
        }
        catch (Exception e) {
            return Collections.emptySet();
        }
    }
}

