/*
 * Decompiled with CFR 0.152.
 */
package com.redlimerl.speedrunigt.mixins;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.redlimerl.speedrunigt.instance.GameInstance;
import com.redlimerl.speedrunigt.timer.InGameTimer;
import com.redlimerl.speedrunigt.timer.TimerAdvancementTracker;
import com.redlimerl.speedrunigt.timer.TimerStatus;
import com.redlimerl.speedrunigt.timer.category.RunCategories;
import com.redlimerl.speedrunigt.timer.category.condition.AdvancementCategoryCondition;
import com.redlimerl.speedrunigt.timer.category.condition.CategoryCondition;
import com.redlimerl.speedrunigt.timer.packet.TimerPacketUtils;
import com.redlimerl.speedrunigt.timer.packet.packets.TimerAchieveAdvancementPacket;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import net.minecraft.class_161;
import net.minecraft.class_163;
import net.minecraft.class_167;
import net.minecraft.class_2779;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_632;
import net.minecraft.class_8781;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_632.class})
public abstract class ClientAdvancementManagerMixin {
    @Shadow
    @Final
    private class_163 field_46144;
    @Shadow
    @Final
    private class_310 field_3684;
    @Shadow
    @Final
    private Map<class_161, class_167> field_3681;

    @Shadow
    public abstract class_163 method_53814();

    @ModifyVariable(method={"onAdvancements"}, at=@At(value="INVOKE", target="Ljava/util/Map$Entry;getValue()Ljava/lang/Object;"))
    public Map.Entry<class_2960, class_167> advancement(Map.Entry<class_2960, class_167> entry) {
        InGameTimer timer = InGameTimer.getInstance();
        class_8781 advancement = this.field_46144.method_716(entry.getKey());
        class_167 advancementProgress = entry.getValue();
        assert (advancement != null);
        advancementProgress.method_727(advancement.method_53647().comp_1916());
        if (advancementProgress.method_740() && timer.getStatus() != TimerStatus.NONE) {
            GameInstance.getInstance().callEvents("advancement", factory -> advancement.method_53649().comp_1919().method_12832().equalsIgnoreCase(factory.getDataValue("advancement")));
            if (Objects.equals(advancement.method_53649().comp_1919().method_12832(), "story/follow_ender_eye")) {
                timer.tryInsertNewTimeline("enter_stronghold");
            } else if (Objects.equals(advancement.method_53649().comp_1919().method_12832(), "nether/find_bastion")) {
                timer.tryInsertNewTimeline("enter_bastion");
            } else if (Objects.equals(advancement.method_53649().comp_1919().method_12832(), "nether/find_fortress")) {
                timer.tryInsertNewTimeline("enter_fortress");
            }
            timer.tryInsertNewAdvancement(advancement.method_53649().comp_1919().toString(), null, advancement.method_53647().comp_1913().isPresent());
            if (timer.isCoop() && advancement.method_53647().comp_1913().isPresent()) {
                TimerPacketUtils.sendClient2ServerPacket(this.field_3684, new TimerAchieveAdvancementPacket(advancement.method_53649()));
            }
            if (timer.getCategory().getConditionJson() != null) {
                for (CategoryCondition.Condition condition : timer.getCustomCondition().map(CategoryCondition::getConditionList).orElse(Lists.newArrayList())) {
                    if (!(condition instanceof AdvancementCategoryCondition)) continue;
                    timer.updateCondition((AdvancementCategoryCondition)condition, advancement.method_53649());
                }
                timer.checkConditions();
            }
            if (timer.getCategory() == RunCategories.HOW_DID_WE_GET_HERE && Objects.equals(advancement.method_53649().comp_1919().toString(), class_2960.method_60654((String)"nether/all_effects").toString())) {
                InGameTimer.complete();
            }
            if (timer.getCategory() == RunCategories.HERO_OF_VILLAGE && Objects.equals(advancement.method_53649().comp_1919().toString(), class_2960.method_60654((String)"adventure/hero_of_the_village").toString())) {
                InGameTimer.complete();
            }
            if (timer.getCategory() == RunCategories.ARBALISTIC && Objects.equals(advancement.method_53649().comp_1919().toString(), class_2960.method_60654((String)"adventure/arbalistic").toString())) {
                InGameTimer.complete();
            }
            if (timer.getCategory() == RunCategories.COVER_ME_IN_DEBRIS && Objects.equals(advancement.method_53649().comp_1919().toString(), class_2960.method_60654((String)"nether/netherite_armor").toString())) {
                InGameTimer.complete();
            }
        }
        return entry;
    }

    @Inject(at={@At(value="RETURN")}, method={"onAdvancements"})
    public void onComplete(class_2779 packet, CallbackInfo ci) {
        int maxCount;
        InGameTimer timer = InGameTimer.getInstance();
        int n = maxCount = timer.getMoreData(7441) == 0 ? 80 : timer.getMoreData(7441);
        if (timer.getStatus() != TimerStatus.NONE && timer.getCategory() == RunCategories.ALL_ADVANCEMENTS && this.getCompleteAdvancementsCount() >= maxCount) {
            InGameTimer.complete();
        }
        if (timer.getStatus() != TimerStatus.NONE && timer.getCategory() == RunCategories.HALF && this.getCompleteAdvancementsCount() >= class_3532.method_15386((float)((float)maxCount / 2.0f))) {
            InGameTimer.complete();
        }
        if (timer.getStatus() != TimerStatus.NONE && timer.getCategory() == RunCategories.POGLOOT_QUATER && this.getCompleteAdvancementsCount() >= class_3532.method_15386((float)((float)maxCount / 4.0f))) {
            InGameTimer.complete();
        }
    }

    @Unique
    private int getCompleteAdvancementsCount() {
        HashSet completedAdvancements = Sets.newHashSet();
        for (Map.Entry<String, TimerAdvancementTracker.AdvancementTrack> track : InGameTimer.getInstance().getAdvancementsTracker().getAdvancements().entrySet()) {
            if (!track.getValue().isAdvancement() || !track.getValue().isComplete()) continue;
            completedAdvancements.add(track.getKey());
        }
        for (class_8781 advancement : this.method_53814().method_53693()) {
            if (!this.field_3681.containsKey(advancement.method_53647()) || !advancement.method_53647().comp_1913().isPresent()) continue;
            class_167 advancementProgress = this.field_3681.get(advancement.method_53647());
            advancementProgress.method_727(advancement.method_53647().comp_1916());
            String advancementID = advancement.method_53649().comp_1919().toString();
            if (!advancementProgress.method_740() || !completedAdvancements.contains(advancementID)) continue;
            completedAdvancements.add(advancementID);
            InGameTimer.getInstance().tryInsertNewAdvancement(advancementID, null, true);
        }
        return completedAdvancements.size();
    }
}

