/*
 * Decompiled with CFR 0.152.
 */
package com.redlimerl.speedrunigt.mixins;

import com.redlimerl.speedrunigt.timer.InGameTimer;
import com.redlimerl.speedrunigt.timer.category.RunCategories;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2812;
import net.minecraft.class_2818;
import net.minecraft.class_2874;
import net.minecraft.class_2897;
import net.minecraft.class_2902;
import net.minecraft.class_310;
import net.minecraft.class_5269;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_638;
import net.minecraft.class_6880;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_638.class})
public abstract class ClientWorldMixin
extends class_1937 {
    @Shadow
    @Final
    private class_310 field_3729;

    @Shadow
    public abstract class_638.class_5271 method_28104();

    protected ClientWorldMixin(class_5269 properties, class_5321<class_1937> registryRef, class_5455 registryManager, class_6880<class_2874> dimensionEntry, boolean isClient, boolean debugWorld, long seed, int maxChainedNeighborUpdates) {
        super(properties, registryRef, registryManager, dimensionEntry, isClient, debugWorld, seed, maxChainedNeighborUpdates);
    }

    @Inject(at={@At(value="HEAD")}, method={"tick"})
    public void onTick(CallbackInfo ci) {
        InGameTimer.getInstance().tick();
    }

    @Inject(method={"updateListeners"}, at={@At(value="TAIL")})
    public void onBlockUpdate(class_2338 pos, class_2680 oldState, class_2680 newState, int flags, CallbackInfo ci) {
        if (this.method_8597().comp_643()) {
            return;
        }
        InGameTimer timer = InGameTimer.getInstance();
        if (timer.getCategory() == RunCategories.MINE_A_CHUNK) {
            int chunkX = pos.method_10263() >> 4;
            int chunkZ = pos.method_10260() >> 4;
            for (int i = -1; i < 2; ++i) {
                for (int j = -1; j < 2; ++j) {
                    if (!(this.method_8497(chunkX + i, chunkZ + j) instanceof class_2812)) continue;
                    return;
                }
            }
            int[][] heightmapAccumulator = new int[48][48];
            for (int x = 0; x < 48; ++x) {
                for (int z = 0; z < 48; ++z) {
                    class_2818 chunk = this.method_8497(chunkX + (x >> 4) - 1, chunkZ + (z >> 4) - 1);
                    int height = chunk.method_12032(class_2902.class_2903.field_13202).method_12603(ClientWorldMixin.mod(x, 16), ClientWorldMixin.mod(z, 16));
                    if (height <= this.getBedrockMaxHeight()) {
                        if (x == 0 || z == 0) {
                            heightmapAccumulator[x][z] = 1;
                            continue;
                        }
                        int currentSquareLevel = Math.min(Math.min(heightmapAccumulator[x - 1][z], heightmapAccumulator[x][z - 1]), heightmapAccumulator[x - 1][z - 1]) + 1;
                        if (currentSquareLevel == 16) {
                            InGameTimer.complete();
                            return;
                        }
                        heightmapAccumulator[x][z] = currentSquareLevel;
                        continue;
                    }
                    heightmapAccumulator[x][z] = 0;
                }
            }
        }
    }

    @Unique
    private static int mod(int divisor, int dividend) {
        return (divisor % dividend + dividend) % dividend;
    }

    @Unique
    private int getBedrockMaxHeight() {
        if (this.field_3729.method_1496() && this.field_3729.method_1576().method_3847(this.method_27983()).method_14178().method_12129() instanceof class_2897) {
            return this.method_31607() + 1;
        }
        return this.method_31607() + 5;
    }

    @Unique
    private void printHeightmapAccumulator(int[][] heightmap) {
        int[][] nArray = heightmap;
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            int[] row;
            for (int height : row = nArray[i]) {
                System.out.printf("%02d ", height);
            }
            System.out.println();
        }
        System.out.println();
    }

    @Unique
    private void printHeightmap(int chunkX, int chunkZ) {
        for (int x = 0; x < 48; ++x) {
            for (int z = 0; z < 48; ++z) {
                class_2818 chunk = this.method_8497(chunkX + (x >> 4) - 1, chunkZ + (z >> 4) - 1);
                int height = chunk.method_12032(class_2902.class_2903.field_13202).method_12603(ClientWorldMixin.mod(x, 16), ClientWorldMixin.mod(z, 16));
                System.out.printf("%02d ", height);
            }
            System.out.println();
        }
        System.out.println();
    }
}

