/*
 * Decompiled with CFR 0.152.
 */
package com.redlimerl.speedrunigt.mixins;

import com.redlimerl.speedrunigt.SpeedRunIGT;
import com.redlimerl.speedrunigt.gui.screen.FailedCategoryInitScreen;
import com.redlimerl.speedrunigt.instance.GameInstance;
import com.redlimerl.speedrunigt.mixins.access.FontManagerAccessor;
import com.redlimerl.speedrunigt.mixins.access.MinecraftClientAccessor;
import com.redlimerl.speedrunigt.option.SpeedRunOption;
import com.redlimerl.speedrunigt.timer.InGameTimer;
import com.redlimerl.speedrunigt.timer.InGameTimerClientUtils;
import com.redlimerl.speedrunigt.timer.InGameTimerUtils;
import com.redlimerl.speedrunigt.timer.TimerDrawer;
import com.redlimerl.speedrunigt.timer.TimerStatus;
import com.redlimerl.speedrunigt.timer.category.RunCategories;
import com.redlimerl.speedrunigt.utils.FontUtils;
import java.io.File;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.class_11642;
import net.minecraft.class_128;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_315;
import net.minecraft.class_3300;
import net.minecraft.class_3302;
import net.minecraft.class_3304;
import net.minecraft.class_3695;
import net.minecraft.class_377;
import net.minecraft.class_390;
import net.minecraft.class_3928;
import net.minecraft.class_4080;
import net.minecraft.class_437;
import net.minecraft.class_542;
import net.minecraft.class_638;
import net.minecraft.class_7134;
import net.minecraft.class_9243;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_310.class})
public abstract class MinecraftClientMixin {
    @Shadow
    @Final
    public class_315 field_1690;
    @Shadow
    @Nullable
    public class_638 field_1687;
    @Shadow
    @Final
    private class_3304 field_1745;
    @Shadow
    private boolean field_1734;
    @Unique
    private int saveTickCount = 0;

    @Inject(method={"setScreen"}, at={@At(value="RETURN")})
    public void onSetScreen(class_437 screen, CallbackInfo ci) {
        if (screen instanceof class_3928) {
            InGameTimerUtils.CAN_DISCONNECT = true;
        }
        if (InGameTimerClientUtils.FAILED_CATEGORY_INIT_SCREEN != null) {
            FailedCategoryInitScreen screen1 = InGameTimerClientUtils.FAILED_CATEGORY_INIT_SCREEN;
            InGameTimerClientUtils.FAILED_CATEGORY_INIT_SCREEN = null;
            class_310.method_1551().method_1507((class_437)screen1);
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"joinWorld"})
    public void onJoin(class_638 world, CallbackInfo ci) {
        InGameTimer timer = InGameTimer.getInstance();
        if (timer.getStatus() == TimerStatus.NONE) {
            return;
        }
        InGameTimerUtils.IS_CHANGING_DIMENSION = false;
        timer.setPause(true, TimerStatus.IDLE, "changed dimension");
        if (Objects.equals(world.method_27983().method_29177().toString(), class_7134.field_37671.toString())) {
            timer.tryInsertNewTimeline("enter_nether");
        } else if (Objects.equals(world.method_27983().method_29177().toString(), class_7134.field_37672.toString())) {
            timer.tryInsertNewTimeline("enter_end");
        }
        if (timer.getCategory() == RunCategories.ENTER_NETHER && Objects.equals(world.method_27983().method_29177().toString(), class_7134.field_37671.toString())) {
            InGameTimer.complete();
            return;
        }
        if (timer.getCategory() == RunCategories.ENTER_END && Objects.equals(world.method_27983().method_29177().toString(), class_7134.field_37672.toString())) {
            InGameTimer.complete();
        }
        RunCategories.checkAllBossesCompleted();
    }

    @Inject(method={"tick"}, at={@At(value="RETURN")})
    private void onTickMixin(CallbackInfo ci) {
        if (++this.saveTickCount >= 20) {
            SpeedRunOption.checkSave();
            this.saveTickCount = 0;
        }
    }

    @Inject(method={"render(Z)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/util/Util;getMeasuringTimeNano()J", shift=At.Shift.AFTER)})
    private void renderMixin(boolean tick, CallbackInfo ci) {
        InGameTimer timer = InGameTimer.getInstance();
        if (timer.getStatus() == TimerStatus.RUNNING && this.field_1734) {
            timer.setPause(true, TimerStatus.PAUSED, "player");
            if (InGameTimerClientUtils.getGeneratedChunkRatio() < 0.1f) {
                InGameTimerUtils.RETIME_IS_WAITING_LOAD = true;
            }
        } else if (timer.getStatus() == TimerStatus.PAUSED && !this.field_1734) {
            timer.setPause(false, "player");
        }
    }

    @Inject(method={"<init>"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/MinecraftClient;onFontOptionsChanged()V")})
    public void onInit(class_542 args, CallbackInfo ci) {
        this.field_1745.method_14477((class_3302)new class_4080<Map<class_2960, List<class_390>>>(){

            protected Map<class_2960, List<class_390>> prepare(class_3300 manager, class_3695 profiler) {
                SpeedRunIGT.FONT_MAPS.clear();
                HashMap<class_2960, List<class_390>> map = new HashMap<class_2960, List<class_390>>();
                File[] fontFiles = SpeedRunIGT.FONT_PATH.toFile().listFiles();
                if (fontFiles == null) {
                    return new HashMap<class_2960, List<class_390>>();
                }
                for (File file2 : Arrays.stream(fontFiles).filter(file -> file.getName().endsWith(".ttf") || file.getName().endsWith(".otf")).toList()) {
                    try {
                        File config = SpeedRunIGT.FONT_PATH.resolve(file2.getName().substring(0, file2.getName().length() - 4) + ".json").toFile();
                        if (config.exists()) {
                            FontUtils.addFont(map, file2, config);
                            continue;
                        }
                        FontUtils.addFont(map, file2, null);
                    }
                    catch (Throwable e) {
                        SpeedRunIGT.error("Failed to load " + file2.getName() + " font file");
                        e.printStackTrace();
                    }
                }
                return map;
            }

            protected void apply(Map<class_2960, List<class_390>> loader, class_3300 manager, class_3695 profiler) {
                try {
                    EnumSet<class_9243> set = EnumSet.noneOf(class_9243.class);
                    if (((Boolean)MinecraftClientMixin.this.field_1690.method_42437().method_41753()).booleanValue()) {
                        set.add(class_9243.field_49112);
                    }
                    if (((Boolean)MinecraftClientMixin.this.field_1690.method_57018().method_41753()).booleanValue()) {
                        set.add(class_9243.field_49113);
                    }
                    FontManagerAccessor fontManager = (FontManagerAccessor)((MinecraftClientAccessor)class_310.method_1551()).getFontManager();
                    for (Map.Entry<class_2960, List<class_390>> listEntry : loader.entrySet()) {
                        class_11642 glyphBaker = new class_11642(fontManager.getTextureManager(), listEntry.getKey());
                        class_377 fontStorage = new class_377(glyphBaker);
                        fontStorage.method_2004(listEntry.getValue().stream().map(font -> new class_390.class_9241(font, class_9243.class_9244.field_49118)).collect(Collectors.toList()), set);
                        fontManager.getFontStorages().put(listEntry.getKey(), fontStorage);
                    }
                    TimerDrawer.fontHeightMap.clear();
                }
                catch (Throwable e) {
                    SpeedRunIGT.error("Error! failed import timer fonts!");
                    e.printStackTrace();
                }
            }
        });
    }

    @Inject(method={"cleanUpAfterCrash"}, at={@At(value="HEAD")})
    private void onCrash(CallbackInfo ci) {
        if (InGameTimer.getInstance().getStatus() != TimerStatus.NONE) {
            InGameTimer.leave();
        }
    }

    @Inject(method={"printCrashReport(Lnet/minecraft/client/MinecraftClient;Ljava/io/File;Lnet/minecraft/util/crash/CrashReport;)V"}, at={@At(value="HEAD")})
    private static void onCrash(class_310 client, File runDirectory, class_128 crashReport, CallbackInfo ci) {
        if (InGameTimer.getInstance().getStatus() != TimerStatus.NONE) {
            InGameTimer.leave();
        }
    }

    @Inject(method={"stop"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/MinecraftClient;close()V")})
    public void onStop(CallbackInfo ci) {
        InGameTimer.getInstance().writeRecordFile(false);
    }

    @Inject(at={@At(value="HEAD")}, method={"disconnect*"})
    public void disconnect(CallbackInfo ci) {
        if (InGameTimer.getInstance().getStatus() != TimerStatus.NONE && InGameTimerUtils.CAN_DISCONNECT) {
            GameInstance.getInstance().callEvents("leave_world");
            InGameTimer.leave();
        }
    }
}

